/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.duplications.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.sonar.duplications.block.Block;
import org.sonar.duplications.block.ByteArray;
import org.sonar.duplications.index.AbstractCloneIndex;
import org.sonar.duplications.index.DataUtils;
import org.sonar.duplications.utils.FastStringComparator;

public class PackedMemoryCloneIndex
extends AbstractCloneIndex {
    private static final int DEFAULT_INITIAL_CAPACITY = 1024;
    private static final int BLOCK_INTS = 5;
    private final int hashInts;
    private final int blockInts;
    private boolean sorted = false;
    private int size;
    private String[] resourceIds;
    private int[] blockData;
    private int[] resourceIdsIndex;
    private final Block.Builder blockBuilder = Block.builder();
    private final DataUtils.Sortable byBlockHash = new DataUtils.Sortable(){

        @Override
        public void swap(int i2, int j) {
            String tmp = PackedMemoryCloneIndex.this.resourceIds[i2];
            PackedMemoryCloneIndex.this.resourceIds[i2] = PackedMemoryCloneIndex.this.resourceIds[j];
            PackedMemoryCloneIndex.this.resourceIds[j] = tmp;
            i2 *= PackedMemoryCloneIndex.this.blockInts;
            j *= PackedMemoryCloneIndex.this.blockInts;
            int k = 0;
            while (k < PackedMemoryCloneIndex.this.blockInts) {
                int x = PackedMemoryCloneIndex.this.blockData[i2];
                PackedMemoryCloneIndex.this.blockData[i2] = PackedMemoryCloneIndex.this.blockData[j];
                PackedMemoryCloneIndex.this.blockData[j] = x;
                ++k;
                ++i2;
                ++j;
            }
        }

        @Override
        public boolean isLess(int i2, int j) {
            return PackedMemoryCloneIndex.this.isLessByHash(i2, j);
        }

        @Override
        public int size() {
            return PackedMemoryCloneIndex.this.size;
        }
    };
    private final DataUtils.Sortable byResourceId = new DataUtils.Sortable(){

        @Override
        public void swap(int i2, int j) {
            int tmp = PackedMemoryCloneIndex.this.resourceIdsIndex[i2];
            PackedMemoryCloneIndex.this.resourceIdsIndex[i2] = PackedMemoryCloneIndex.this.resourceIdsIndex[j];
            PackedMemoryCloneIndex.this.resourceIdsIndex[j] = tmp;
        }

        @Override
        public boolean isLess(int i2, int j) {
            String s1 = PackedMemoryCloneIndex.this.resourceIds[PackedMemoryCloneIndex.this.resourceIdsIndex[i2]];
            String s2 = PackedMemoryCloneIndex.this.resourceIds[PackedMemoryCloneIndex.this.resourceIdsIndex[j]];
            return FastStringComparator.INSTANCE.compare(s1, s2) < 0;
        }

        @Override
        public int size() {
            return PackedMemoryCloneIndex.this.size;
        }
    };

    public PackedMemoryCloneIndex() {
        this(8, 1024);
    }

    public PackedMemoryCloneIndex(int hashBytes, int initialCapacity) {
        this.hashInts = hashBytes / 4;
        this.blockInts = this.hashInts + 5;
        this.size = 0;
        this.resourceIds = new String[initialCapacity];
        this.blockData = new int[initialCapacity * this.blockInts];
        this.resourceIdsIndex = new int[initialCapacity];
    }

    @Override
    public Collection<Block> getByResourceId(String resourceId) {
        this.ensureSorted();
        this.resourceIds[this.size] = resourceId;
        this.resourceIdsIndex[this.size] = this.size;
        int index = DataUtils.binarySearch(this.byResourceId);
        ArrayList<Block> result = new ArrayList<Block>();
        int realIndex = this.resourceIdsIndex[index];
        while (index < this.size && FastStringComparator.INSTANCE.compare(this.resourceIds[realIndex], resourceId) == 0) {
            result.add(this.getBlock(realIndex, resourceId));
            realIndex = this.resourceIdsIndex[++index];
        }
        return result;
    }

    private Block createBlock(int index, String resourceId, @Nullable ByteArray byteHash) {
        ByteArray blockHash;
        int offset = index * this.blockInts;
        if (byteHash == null) {
            int[] hash = new int[this.hashInts];
            for (int j = 0; j < this.hashInts; ++j) {
                hash[j] = this.blockData[offset++];
            }
            blockHash = new ByteArray(hash);
        } else {
            blockHash = byteHash;
            offset += this.hashInts;
        }
        int indexInFile = this.blockData[offset++];
        int firstLineNumber = this.blockData[offset++];
        int lastLineNumber = this.blockData[offset++];
        int startUnit = this.blockData[offset++];
        int endUnit = this.blockData[offset];
        return this.blockBuilder.setResourceId(resourceId).setBlockHash(blockHash).setIndexInFile(indexInFile).setLines(firstLineNumber, lastLineNumber).setUnit(startUnit, endUnit).build();
    }

    private Block getBlock(int index, String resourceId) {
        return this.createBlock(index, resourceId, null);
    }

    @Override
    public Iterator<ResourceBlocks> iterator() {
        this.ensureSorted();
        return new ResourceIterator();
    }

    @Override
    public Collection<Block> getBySequenceHash(ByteArray sequenceHash) {
        this.ensureSorted();
        int[] hash = sequenceHash.toIntArray();
        if (hash.length != this.hashInts) {
            throw new IllegalArgumentException("Expected " + this.hashInts + " ints in hash, but got " + hash.length);
        }
        int offset = this.size * this.blockInts;
        for (int i2 = 0; i2 < this.hashInts; ++i2) {
            this.blockData[offset++] = hash[i2];
        }
        ArrayList<Block> result = new ArrayList<Block>();
        for (int index = DataUtils.binarySearch(this.byBlockHash); index < this.size && !this.isLessByHash(this.size, index); ++index) {
            String resourceId = this.resourceIds[index];
            result.add(this.createBlock(index, resourceId, sequenceHash));
        }
        return result;
    }

    @Override
    public void insert(Block block) {
        this.sorted = false;
        this.ensureCapacity();
        this.resourceIds[this.size] = block.getResourceId();
        int[] hash = block.getBlockHash().toIntArray();
        if (hash.length != this.hashInts) {
            throw new IllegalArgumentException("Expected " + this.hashInts + " ints in hash, but got " + hash.length);
        }
        int offset = this.size * this.blockInts;
        for (int i2 = 0; i2 < this.hashInts; ++i2) {
            this.blockData[offset++] = hash[i2];
        }
        this.blockData[offset++] = block.getIndexInFile();
        this.blockData[offset++] = block.getStartLine();
        this.blockData[offset++] = block.getEndLine();
        this.blockData[offset++] = block.getStartUnit();
        this.blockData[offset] = block.getEndUnit();
        ++this.size;
    }

    private void ensureCapacity() {
        if (this.size < this.resourceIds.length) {
            return;
        }
        int newCapacity = this.resourceIds.length * 3 / 2 + 1;
        String[] oldResourceIds = this.resourceIds;
        this.resourceIds = new String[newCapacity];
        System.arraycopy(oldResourceIds, 0, this.resourceIds, 0, oldResourceIds.length);
        int[] oldBlockData = this.blockData;
        this.blockData = new int[newCapacity * this.blockInts];
        System.arraycopy(oldBlockData, 0, this.blockData, 0, oldBlockData.length);
        this.resourceIdsIndex = new int[newCapacity];
        this.sorted = false;
    }

    private void ensureSorted() {
        if (this.sorted) {
            return;
        }
        this.ensureCapacity();
        DataUtils.sort(this.byBlockHash);
        for (int i2 = 0; i2 < this.size; ++i2) {
            this.resourceIdsIndex[i2] = i2;
        }
        DataUtils.sort(this.byResourceId);
        this.sorted = true;
    }

    private boolean isLessByHash(int i2, int j) {
        int i22 = i2 * this.blockInts;
        int j2 = j * this.blockInts;
        int k = 0;
        while (k < this.hashInts) {
            if (this.blockData[i22] < this.blockData[j2]) {
                return true;
            }
            if (this.blockData[i22] > this.blockData[j2]) {
                return false;
            }
            ++k;
            ++i22;
            ++j2;
        }
        return false;
    }

    @Override
    public int noResources() {
        this.ensureSorted();
        int count = 0;
        String lastResource = null;
        for (int i2 = 0; i2 < this.size; ++i2) {
            String resource = this.resourceIds[this.resourceIdsIndex[i2]];
            if (resource == null || resource.equals(lastResource)) continue;
            ++count;
            lastResource = resource;
        }
        return count;
    }

    private class ResourceIterator
    implements Iterator<ResourceBlocks> {
        private int index = 0;

        private ResourceIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < PackedMemoryCloneIndex.this.size;
        }

        @Override
        public ResourceBlocks next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String resourceId = PackedMemoryCloneIndex.this.resourceIds[PackedMemoryCloneIndex.this.resourceIdsIndex[this.index]];
            ArrayList<Block> blocks = new ArrayList<Block>();
            do {
                blocks.add(PackedMemoryCloneIndex.this.getBlock(PackedMemoryCloneIndex.this.resourceIdsIndex[this.index], resourceId));
                ++this.index;
            } while (this.hasNext() && FastStringComparator.INSTANCE.compare(PackedMemoryCloneIndex.this.resourceIds[PackedMemoryCloneIndex.this.resourceIdsIndex[this.index]], resourceId) == 0);
            return new ResourceBlocks(resourceId, blocks);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class ResourceBlocks {
        private Collection<Block> blocks;
        private String resourceId;

        public ResourceBlocks(String resourceId, Collection<Block> blocks) {
            this.resourceId = resourceId;
            this.blocks = blocks;
        }

        public Collection<Block> blocks() {
            return this.blocks;
        }

        public String resourceId() {
            return this.resourceId;
        }
    }
}

