/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.duplications.index;

public final class DataUtils {
    public static int binarySearch(Sortable data) {
        int value = data.size();
        int lower = 0;
        int upper = data.size();
        while (lower < upper) {
            int mid = lower + upper >> 1;
            if (data.isLess(mid, value)) {
                lower = mid + 1;
                continue;
            }
            upper = mid;
        }
        return lower;
    }

    public static void sort(Sortable data) {
        DataUtils.quickSort(data, 0, data.size() - 1);
    }

    private static void bubbleSort(Sortable data, int left, int right) {
        for (int i2 = right; i2 > left; --i2) {
            for (int j = left; j < i2; ++j) {
                if (!data.isLess(j + 1, j)) continue;
                data.swap(j, j + 1);
            }
        }
    }

    private static int partition(Sortable data, int i2, int j) {
        int pivot = i2 + (j - i2) / 2;
        while (i2 <= j) {
            while (data.isLess(i2, pivot)) {
                ++i2;
            }
            while (data.isLess(pivot, j)) {
                --j;
            }
            if (i2 > j) continue;
            data.swap(i2, j);
            if (i2 == pivot) {
                pivot = j;
            } else if (j == pivot) {
                pivot = i2;
            }
            ++i2;
            --j;
        }
        return i2;
    }

    private static void quickSort(Sortable data, int low, int high) {
        if (high - low < 5) {
            DataUtils.bubbleSort(data, low, high);
            return;
        }
        int i2 = DataUtils.partition(data, low, high);
        if (low < i2 - 1) {
            DataUtils.quickSort(data, low, i2 - 1);
        }
        if (i2 < high) {
            DataUtils.quickSort(data, i2, high);
        }
    }

    private DataUtils() {
    }

    public static interface Sortable {
        public int size();

        public void swap(int var1, int var2);

        public boolean isLess(int var1, int var2);
    }
}

