/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.duplications.detector.suffixtree;

import org.sonar.duplications.detector.suffixtree.Node;
import org.sonar.duplications.detector.suffixtree.Suffix;

public final class Edge {
    private int beginIndex;
    private int endIndex;
    private Node startNode;
    private Node endNode;

    public Edge(int beginIndex, int endIndex, Node startNode) {
        this.beginIndex = beginIndex;
        this.endIndex = endIndex;
        this.startNode = startNode;
        this.endNode = new Node(startNode, null);
    }

    public Node splitEdge(Suffix suffix) {
        this.remove();
        Edge newEdge = new Edge(this.beginIndex, this.beginIndex + suffix.getSpan(), suffix.getOriginNode());
        newEdge.insert();
        newEdge.endNode.setSuffixNode(suffix.getOriginNode());
        this.beginIndex += suffix.getSpan() + 1;
        this.startNode = newEdge.getEndNode();
        this.insert();
        return newEdge.getEndNode();
    }

    public void insert() {
        this.startNode.addEdge(this.beginIndex, this);
    }

    public void remove() {
        this.startNode.removeEdge(this.beginIndex);
    }

    public int getSpan() {
        return this.endIndex - this.beginIndex;
    }

    public int getBeginIndex() {
        return this.beginIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public Node getStartNode() {
        return this.startNode;
    }

    public Node getEndNode() {
        return this.endNode;
    }
}

