/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.duplications.block;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;

public final class ByteArray {
    private static final String HEXES = "0123456789abcdef";
    private final byte[] bytes;
    private int hash;

    public ByteArray(String hexString) {
        int len = hexString.length();
        this.bytes = new byte[len / 2];
        for (int i2 = 0; i2 < len; i2 += 2) {
            this.bytes[i2 / 2] = (byte)((Character.digit(hexString.charAt(i2), 16) << 4) + Character.digit(hexString.charAt(i2 + 1), 16));
        }
    }

    public ByteArray(byte[] bytes) {
        this.bytes = new byte[bytes.length];
        System.arraycopy(bytes, 0, this.bytes, 0, bytes.length);
    }

    public ByteArray(long value) {
        this.bytes = new byte[]{(byte)(value >>> 56), (byte)(value >>> 48), (byte)(value >>> 40), (byte)(value >>> 32), (byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
    }

    public ByteArray(int value) {
        this.bytes = new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
    }

    public ByteArray(int[] intArray) {
        ByteBuffer bb = ByteBuffer.allocate(intArray.length * 4);
        for (int i2 : intArray) {
            bb.putInt(i2);
        }
        this.bytes = bb.array();
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int[] toIntArray() {
        int size = this.bytes.length / 4 + (this.bytes.length % 4 == 0 ? 0 : 1);
        ByteBuffer bb = ByteBuffer.allocate(size * 4);
        bb.put(this.bytes);
        bb.rewind();
        IntBuffer ib = bb.asIntBuffer();
        int[] result = new int[size];
        ib.get(result);
        return result;
    }

    public String toHexString() {
        StringBuilder hex = new StringBuilder(2 * this.bytes.length);
        for (byte b : this.bytes) {
            hex.append(HEXES.charAt((b & 0xF0) >> 4)).append(HEXES.charAt(b & 0xF));
        }
        return hex.toString();
    }

    public String toString() {
        return this.toHexString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByteArray other = (ByteArray)o;
        return Arrays.equals(this.bytes, other.bytes);
    }

    public int hashCode() {
        int h = this.hash;
        int len = this.bytes.length;
        if (h == 0 && len > 0) {
            this.hash = h = Arrays.hashCode(this.bytes);
        }
        return h;
    }
}

