/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.util.stream;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Stream;

public final class MoreCollectors {
    private static final String KEY_FUNCTION_CANT_RETURN_NULL_MESSAGE = "Key function can't return null";
    private static final String VALUE_FUNCTION_CANT_RETURN_NULL_MESSAGE = "Value function can't return null";

    private MoreCollectors() {
    }

    public static <K, E> Collector<E, ImmutableListMultimap.Builder<K, E>, ImmutableListMultimap<K, E>> index(Function<? super E, K> keyFunction) {
        return MoreCollectors.index(keyFunction, Function.identity());
    }

    public static <K, E, V> Collector<E, ImmutableListMultimap.Builder<K, V>, ImmutableListMultimap<K, V>> index(Function<? super E, K> keyFunction, Function<? super E, V> valueFunction) {
        MoreCollectors.verifyKeyAndValueFunctions(keyFunction, valueFunction);
        BiConsumer<ImmutableListMultimap.Builder, Object> accumulator = (map, element) -> {
            Object key = Objects.requireNonNull(keyFunction.apply((Object)element), KEY_FUNCTION_CANT_RETURN_NULL_MESSAGE);
            Object value = Objects.requireNonNull(valueFunction.apply((Object)element), VALUE_FUNCTION_CANT_RETURN_NULL_MESSAGE);
            map.put(key, value);
        };
        BinaryOperator merger = (m1, m2) -> {
            for (Map.Entry entry : m2.build().entries()) {
                m1.put(entry.getKey(), entry.getValue());
            }
            return m1;
        };
        return Collector.of(ImmutableListMultimap::builder, accumulator, merger, ImmutableListMultimap.Builder::build, new Collector.Characteristics[0]);
    }

    public static <K, E> Collector<E, ImmutableSetMultimap.Builder<K, E>, ImmutableSetMultimap<K, E>> unorderedIndex(Function<? super E, K> keyFunction) {
        return MoreCollectors.unorderedIndex(keyFunction, Function.identity());
    }

    public static <K, E, V> Collector<E, ImmutableSetMultimap.Builder<K, V>, ImmutableSetMultimap<K, V>> unorderedIndex(Function<? super E, K> keyFunction, Function<? super E, V> valueFunction) {
        MoreCollectors.verifyKeyAndValueFunctions(keyFunction, valueFunction);
        BiConsumer<ImmutableSetMultimap.Builder, Object> accumulator = (map, element) -> {
            Object key = Objects.requireNonNull(keyFunction.apply((Object)element), KEY_FUNCTION_CANT_RETURN_NULL_MESSAGE);
            Object value = Objects.requireNonNull(valueFunction.apply((Object)element), VALUE_FUNCTION_CANT_RETURN_NULL_MESSAGE);
            map.put(key, value);
        };
        BinaryOperator merger = (m1, m2) -> {
            for (Map.Entry entry : ((ImmutableSetMultimap)m2.build()).entries()) {
                m1.put(entry.getKey(), entry.getValue());
            }
            return m1;
        };
        return Collector.of(ImmutableSetMultimap::builder, accumulator, merger, ImmutableSetMultimap.Builder::build, new Collector.Characteristics[0]);
    }

    public static <K, E, V> Collector<E, ImmutableSetMultimap.Builder<K, V>, ImmutableSetMultimap<K, V>> unorderedFlattenIndex(Function<? super E, K> keyFunction, Function<? super E, Stream<V>> valueFunction) {
        MoreCollectors.verifyKeyAndValueFunctions(keyFunction, valueFunction);
        BiConsumer<ImmutableSetMultimap.Builder, Object> accumulator = (map, element) -> {
            Object key = Objects.requireNonNull(keyFunction.apply((Object)element), KEY_FUNCTION_CANT_RETURN_NULL_MESSAGE);
            Stream valueStream = Objects.requireNonNull((Stream)valueFunction.apply((Object)element), VALUE_FUNCTION_CANT_RETURN_NULL_MESSAGE);
            valueStream.forEach(value -> map.put(key, value));
        };
        BinaryOperator merger = (m1, m2) -> {
            for (Map.Entry entry : ((ImmutableSetMultimap)m2.build()).entries()) {
                m1.put(entry.getKey(), entry.getValue());
            }
            return m1;
        };
        return Collector.of(ImmutableSetMultimap::builder, accumulator, merger, ImmutableSetMultimap.Builder::build, new Collector.Characteristics[0]);
    }

    private static void verifyKeyAndValueFunctions(Function<?, ?> keyFunction, Function<?, ?> valueFunction) {
        Objects.requireNonNull(keyFunction, "Key function can't be null");
        Objects.requireNonNull(valueFunction, "Value function can't be null");
    }
}

