/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.util.rule;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.issue.impact.Severity;
import org.sonar.api.issue.impact.SoftwareQuality;
import org.sonar.core.util.ParamChange;

public class RuleChange
implements Serializable {
    private String key;
    private String language;
    private String templateKey;
    private String severity;
    private ParamChange[] params = new ParamChange[0];
    private final List<Impact> impacts = new ArrayList<Impact>();

    public String getKey() {
        return this.key;
    }

    public RuleChange setKey(String key) {
        this.key = key;
        return this;
    }

    @CheckForNull
    public String getLanguage() {
        return this.language;
    }

    public RuleChange setLanguage(@Nullable String language) {
        this.language = language;
        return this;
    }

    public String getTemplateKey() {
        return this.templateKey;
    }

    public RuleChange setTemplateKey(String templateKey) {
        this.templateKey = templateKey;
        return this;
    }

    @CheckForNull
    public String getSeverity() {
        return this.severity;
    }

    public RuleChange setSeverity(@Nullable String severity) {
        this.severity = severity;
        return this;
    }

    public ParamChange[] getParams() {
        return this.params;
    }

    public RuleChange setParams(ParamChange[] params) {
        this.params = params;
        return this;
    }

    public List<Impact> getImpacts() {
        return this.impacts;
    }

    public void addImpact(SoftwareQuality softwareQuality, Severity severity) {
        this.impacts.add(new Impact(softwareQuality, severity));
    }

    static class Impact
    implements Serializable {
        private final SoftwareQuality softwareQuality;
        private final Severity severity;

        Impact(SoftwareQuality softwareQuality, Severity severity) {
            this.softwareQuality = softwareQuality;
            this.severity = severity;
        }

        public SoftwareQuality getSoftwareQuality() {
            return this.softwareQuality;
        }

        public Severity getSeverity() {
            return this.severity;
        }
    }
}

