/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.util.issue;

import java.io.Serializable;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.core.util.issue.Issue;

public class IssueChangedEvent
implements Serializable {
    private static final String EVENT = "IssueChanged";
    private final String projectKey;
    private final Issue[] issues;
    @CheckForNull
    private final Boolean resolved;
    @CheckForNull
    private final String userSeverity;
    @CheckForNull
    private final String userType;

    public IssueChangedEvent(String projectKey, Issue[] issues, @Nullable Boolean resolved, @Nullable String userSeverity, @Nullable String userType) {
        if (issues.length == 0) {
            throw new IllegalArgumentException("Can't create IssueChangedEvent without any issues that have changed");
        }
        this.projectKey = projectKey;
        this.issues = issues;
        this.resolved = resolved;
        this.userSeverity = userSeverity;
        this.userType = userType;
    }

    public String getEvent() {
        return EVENT;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public Issue[] getIssues() {
        return this.issues;
    }

    @CheckForNull
    public Boolean getResolved() {
        return this.resolved;
    }

    @CheckForNull
    public String getUserSeverity() {
        return this.userSeverity;
    }

    @CheckForNull
    public String getUserType() {
        return this.userType;
    }
}

