/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;

public final class ResourceUtils {
    private ResourceUtils() {
    }

    public static String readClasspathResource(Class<?> relativeTo, String resourcePath) {
        try {
            InputStream resourceStream = relativeTo.getResourceAsStream(resourcePath);
            if (resourceStream == null) {
                throw new IllegalStateException(ResourceUtils.getErrorMessage(relativeTo, resourcePath));
            }
            return IOUtils.toString(resourceStream, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new IllegalStateException(ResourceUtils.getErrorMessage(relativeTo, resourcePath), e);
        }
    }

    private static String getErrorMessage(Class<?> relativeTo, String resourcePath) {
        return String.format("Fail to read classpath resource: %s of class: %s", resourcePath, relativeTo.getPackageName());
    }
}

