/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.util;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.Parser;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;
import org.sonar.core.util.CloseableIterator;
import org.sonar.core.util.ContextException;

public class Protobuf {
    private Protobuf() {
    }

    public static <MSG extends Message> MSG read(File file, Parser<MSG> parser) {
        Message message;
        BufferedInputStream input = null;
        try {
            input = new BufferedInputStream(new FileInputStream(file));
            message = (Message)parser.parseFrom(input);
        }
        catch (Exception e) {
            try {
                throw ContextException.of("Unable to read message", e).addContext("file", file);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(input);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(input);
        return (MSG)message;
    }

    public static <MSG extends Message> MSG read(InputStream input, Parser<MSG> parser) {
        try {
            Message message = (Message)parser.parseFrom(input);
            return (MSG)message;
        }
        catch (Exception e) {
            throw ContextException.of("Unable to read message", e);
        }
        finally {
            IOUtils.closeQuietly(input);
        }
    }

    public static void write(Message message, File toFile) {
        BufferedOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(toFile, false));
            message.writeTo(out);
        }
        catch (Exception e) {
            try {
                throw ContextException.of("Unable to write message", e).addContext("file", toFile);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(out);
    }

    public static void writeGzip(Message message, File toFile) {
        GZIPOutputStream out = null;
        try {
            out = new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(toFile, false)));
            message.writeTo(out);
        }
        catch (Exception e) {
            try {
                throw ContextException.of("Unable to write message", e).addContext("file", toFile);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(out);
    }

    public static <MSG extends Message> void writeStream(Iterable<MSG> messages, File toFile, boolean append) {
        BufferedOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(toFile, append));
            Protobuf.writeStream(messages, out);
        }
        catch (Exception e) {
            try {
                throw ContextException.of("Unable to write messages", e).addContext("file", toFile);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(out);
    }

    public static <MSG extends Message> void writeStream(Iterable<MSG> messages, OutputStream output) {
        try {
            for (Message message : messages) {
                message.writeDelimitedTo(output);
            }
        }
        catch (Exception e) {
            throw ContextException.of("Unable to write messages", e);
        }
    }

    public static <MSG extends Message> CloseableIterator<MSG> readStream(File file, Parser<MSG> parser) {
        try {
            BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));
            return Protobuf.readStream(input, parser);
        }
        catch (Exception e) {
            throw ContextException.of("Unable to read messages", e).addContext("file", file);
        }
    }

    public static <MSG extends Message> CloseableIterator<MSG> readGzipStream(File file, Parser<MSG> parser) {
        try {
            GZIPInputStream input = new GZIPInputStream(new BufferedInputStream(new FileInputStream(file)));
            return Protobuf.readStream(input, parser);
        }
        catch (Exception e) {
            throw ContextException.of("Unable to read messages", e).addContext("file", file);
        }
    }

    public static <MSG extends Message> CloseableIterator<MSG> readStream(InputStream input, Parser<MSG> parser) {
        return new StreamIterator<MSG>(parser, input);
    }

    private static class StreamIterator<MSG extends Message>
    extends CloseableIterator<MSG> {
        private final Parser<MSG> parser;
        private final InputStream input;

        private StreamIterator(Parser<MSG> parser, InputStream input) {
            this.parser = parser;
            this.input = input;
        }

        @Override
        protected MSG doNext() {
            try {
                return (MSG)((Message)this.parser.parsePartialDelimitedFrom(this.input));
            }
            catch (InvalidProtocolBufferException e) {
                throw ContextException.of(e);
            }
        }

        @Override
        protected void doClose() {
            IOUtils.closeQuietly(this.input);
        }
    }
}

