/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.util;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgressLogger {
    public static final long DEFAULT_PERIOD_MS = 60000L;
    private final Timer timer;
    private final LoggerTimerTask task;
    private long periodMs = 60000L;

    public ProgressLogger(String threadName, AtomicLong counter, Logger logger) {
        this.timer = new Timer(threadName);
        this.task = new LoggerTimerTask(counter, logger);
    }

    public static ProgressLogger create(Class clazz, AtomicLong counter) {
        String threadName = String.format("ProgressLogger[%s]", clazz.getSimpleName());
        Logger logger = LoggerFactory.getLogger(clazz);
        return new ProgressLogger(threadName, counter, logger);
    }

    public void start() {
        this.timer.schedule((TimerTask)this.task, this.periodMs, this.periodMs);
    }

    public void stop() {
        this.timer.cancel();
        this.timer.purge();
    }

    public ProgressLogger setPeriodMs(long l) {
        this.periodMs = l;
        return this;
    }

    public long getPeriodMs() {
        return this.periodMs;
    }

    public ProgressLogger setPluralLabel(String s) {
        this.task.pluralLabel = s;
        return this;
    }

    public String getPluralLabel() {
        return this.task.pluralLabel;
    }

    public void log() {
        this.task.log();
    }

    private class LoggerTimerTask
    extends TimerTask {
        private final AtomicLong counter;
        private final Logger logger;
        private String pluralLabel = "rows";
        private long previousCounter = 0L;

        private LoggerTimerTask(AtomicLong counter, Logger logger) {
            this.counter = counter;
            this.logger = logger;
        }

        @Override
        public void run() {
            this.log();
        }

        private void log() {
            long current = this.counter.get();
            this.logger.atInfo().addArgument(current).addArgument(this.pluralLabel).addArgument(() -> 1000L * (current - this.previousCounter) / ProgressLogger.this.periodMs).log("{} {} processed ({} items/sec)");
            this.previousCounter = current;
        }
    }
}

