/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.util;

import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.LogOutputStream;
import org.apache.commons.exec.PumpStreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessWrapperFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessWrapperFactory.class);

    public ProcessWrapper create(@Nullable Path baseDir, Consumer<String> stdOutLineConsumer, Consumer<String> stdErrLineConsumer, String ... command) {
        return new ProcessWrapper(baseDir, stdOutLineConsumer, stdErrLineConsumer, Map.of(), command);
    }

    public ProcessWrapper create(@Nullable Path baseDir, Consumer<String> stdOutLineConsumer, Consumer<String> stdErrLineConsumer, Map<String, String> envVariablesOverrides, String ... command) {
        return new ProcessWrapper(baseDir, stdOutLineConsumer, stdErrLineConsumer, envVariablesOverrides, command);
    }

    public static class ProcessWrapper {
        private final Path baseDir;
        private final Consumer<String> stdOutLineConsumer;
        private final Consumer<String> stdErrLineConsumer;
        private final String[] command;
        private final Map<String, String> envVariables = new HashMap<String, String>();
        private final AtomicReference<Exception> exceptionWhileProcessingStream = new AtomicReference();
        private ExecuteWatchdog watchdog = null;

        ProcessWrapper(@Nullable Path baseDir, Consumer<String> stdOutLineConsumer, Consumer<String> stdErrLineConsumer, Map<String, String> envVariablesOverrides, String ... command) {
            this.baseDir = baseDir;
            this.stdOutLineConsumer = stdOutLineConsumer;
            this.stdErrLineConsumer = stdErrLineConsumer;
            this.envVariables.putAll(System.getenv());
            this.envVariables.putAll(envVariablesOverrides);
            this.command = command;
        }

        public void execute() throws IOException {
            CommandLine cmdLine = new CommandLine(this.command[0]);
            for (int i2 = 1; i2 < this.command.length; ++i2) {
                cmdLine.addArgument(this.command[i2], false);
            }
            DefaultExecutor executor = this.buildExecutor();
            DefaultExecuteResultHandler resultHandler = new DefaultExecuteResultHandler();
            executor.execute(cmdLine, this.envVariables, resultHandler);
            try {
                resultHandler.waitFor();
                int exitValue = resultHandler.getExitValue();
                if (exitValue == -559038737) {
                    throw resultHandler.getException();
                }
                if (exitValue != 0 && !this.watchdog.killedProcess()) {
                    throw new IllegalStateException(String.format("Command execution exited with code: %d", exitValue), resultHandler.getException());
                }
                if (this.exceptionWhileProcessingStream.get() != null) {
                    throw new IllegalStateException("Error while processing stream for command", this.exceptionWhileProcessingStream.get());
                }
            }
            catch (InterruptedException e) {
                LOG.warn("Command [{}] interrupted", (Object)String.join((CharSequence)" ", this.command), (Object)e);
                Thread.currentThread().interrupt();
            }
        }

        private DefaultExecutor buildExecutor() {
            DefaultExecutor.Builder<?> builder = DefaultExecutor.builder();
            if (this.baseDir != null) {
                builder.setWorkingDirectory(this.baseDir.toFile());
            }
            PumpStreamHandler psh = new PumpStreamHandler(new ExceptionCatchingLogOutputStream(this.stdOutLineConsumer), new ExceptionCatchingLogOutputStream(this.stdErrLineConsumer));
            builder.setExecuteStreamHandler(psh);
            DefaultExecutor executor = builder.get();
            this.watchdog = ExecuteWatchdog.builder().setTimeout(ExecuteWatchdog.INFINITE_TIMEOUT_DURATION).get();
            executor.setWatchdog(this.watchdog);
            return executor;
        }

        public void destroy() {
            this.watchdog.destroyProcess();
        }

        private class ExceptionCatchingLogOutputStream
        extends LogOutputStream {
            private final Consumer<String> lineConsumer;

            public ExceptionCatchingLogOutputStream(Consumer<String> lineConsumer) {
                this.lineConsumer = lineConsumer;
            }

            @Override
            protected void processLine(String line, int logLevel) {
                try {
                    this.lineConsumer.accept(line);
                }
                catch (Exception e) {
                    ProcessWrapper.this.exceptionWhileProcessingStream.compareAndSet(null, e);
                    ProcessWrapper.this.watchdog.destroyProcess();
                }
            }
        }
    }
}

