/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.sarif;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.google.common.annotations.VisibleForTesting;
import jakarta.inject.Inject;
import java.io.IOException;
import java.nio.file.Path;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.core.sarif.SarifSerializer;
import org.sonar.sarif.pojo.SarifSchema210;

@ScannerSide
@ComputeEngineSide
public class SarifSerializerImpl
implements SarifSerializer {
    private static final String SARIF_REPORT_ERROR = "Failed to read SARIF report at '%s'";
    private static final String SARIF_JSON_SYNTAX_ERROR = "Failed to read SARIF report at '%s': invalid JSON syntax or file is not UTF-8 encoded";
    public static final String UNSUPPORTED_VERSION_MESSAGE_TEMPLATE = "Version [%s] of SARIF is not supported";
    private final ObjectMapper mapper;

    @Inject
    public SarifSerializerImpl() {
        this(new ObjectMapper());
    }

    @VisibleForTesting
    SarifSerializerImpl(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public String serialize(SarifSchema210 sarif210) {
        try {
            return this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString(sarif210);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Unable to serialize SARIF", e);
        }
    }

    @Override
    public SarifSchema210 deserialize(Path reportPath) {
        try {
            return this.mapper.enable(JsonParser.Feature.INCLUDE_SOURCE_IN_LOCATION).addHandler(new DeserializationProblemHandler(){

                @Override
                public Object handleInstantiationProblem(DeserializationContext ctxt, Class<?> instClass, Object argument, Throwable t) throws IOException {
                    if (!instClass.equals(SarifSchema210.Version.class)) {
                        return NOT_HANDLED;
                    }
                    throw new UnsupportedSarifVersionException(String.format(SarifSerializerImpl.UNSUPPORTED_VERSION_MESSAGE_TEMPLATE, argument), t);
                }
            }).readValue(reportPath.toFile(), SarifSchema210.class);
        }
        catch (UnsupportedSarifVersionException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new IllegalStateException(String.format(SARIF_JSON_SYNTAX_ERROR, reportPath), e);
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format(SARIF_REPORT_ERROR, reportPath), e);
        }
    }

    private static class UnsupportedSarifVersionException
    extends IOException {
        public UnsupportedSarifVersionException(String message, Throwable t) {
            super(message, t);
        }
    }
}

