/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.rule;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.CheckForNull;

public enum RuleType {
    CODE_SMELL(1),
    BUG(2),
    VULNERABILITY(3),
    SECURITY_HOTSPOT(4);

    private static final Set<String> ALL_NAMES;
    private final int dbConstant;

    private RuleType(int dbConstant) {
        this.dbConstant = dbConstant;
    }

    public int getDbConstant() {
        return this.dbConstant;
    }

    public static Set<String> names() {
        return ALL_NAMES;
    }

    public static RuleType fromDbConstant(int dbConstant) {
        for (RuleType type : RuleType.values()) {
            if (type.getDbConstant() != dbConstant) continue;
            return type;
        }
        throw new IllegalArgumentException(String.format("Unsupported type value : %d", dbConstant));
    }

    @CheckForNull
    public static RuleType valueOfNullable(int dbConstant) {
        for (RuleType type : RuleType.values()) {
            if (type.getDbConstant() != dbConstant) continue;
            return type;
        }
        if (dbConstant == 0) {
            return null;
        }
        throw new IllegalArgumentException(String.format("Unsupported type value : %d", dbConstant));
    }

    static {
        ALL_NAMES = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.stream(RuleType.values()).map(Enum::name).toList()));
    }
}

