/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.rule;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.Optional;
import org.sonar.api.issue.impact.Severity;

public class ImpactSeverityMapper {
    private static final BiMap<Severity, String> SEVERITY_MAPPING = ((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)new ImmutableBiMap.Builder().put((Object)Severity.INFO, "INFO")).put((Object)Severity.LOW, "MINOR")).put((Object)Severity.MEDIUM, "MAJOR")).put((Object)Severity.HIGH, "CRITICAL")).put((Object)Severity.BLOCKER, "BLOCKER")).build();

    private ImpactSeverityMapper() {
    }

    public static Severity mapImpactSeverity(String severity) {
        return Optional.ofNullable((Severity)((Object)SEVERITY_MAPPING.inverse().get(severity))).orElseThrow(() -> new IllegalArgumentException("Severity not supported: " + severity));
    }

    public static String mapRuleSeverity(Severity severity) {
        return Optional.ofNullable((String)SEVERITY_MAPPING.get((Object)severity)).orElseThrow(() -> new IllegalArgumentException("Impact Severity not supported: " + String.valueOf((Object)severity)));
    }
}

