/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.rule;

import org.sonar.api.issue.impact.Severity;
import org.sonarqube.ws.Common;

public class ImpactFormatter {
    private ImpactFormatter() {
    }

    public static Common.ImpactSeverity mapImpactSeverity(Severity severity) {
        return switch (severity) {
            default -> throw new IncompatibleClassChangeError();
            case Severity.BLOCKER -> Common.ImpactSeverity.ImpactSeverity_BLOCKER;
            case Severity.HIGH -> Common.ImpactSeverity.HIGH;
            case Severity.MEDIUM -> Common.ImpactSeverity.MEDIUM;
            case Severity.LOW -> Common.ImpactSeverity.LOW;
            case Severity.INFO -> Common.ImpactSeverity.ImpactSeverity_INFO;
        };
    }

    public static Severity mapImpactSeverity(Common.ImpactSeverity severity) {
        return switch (severity) {
            default -> throw new IncompatibleClassChangeError();
            case Common.ImpactSeverity.ImpactSeverity_BLOCKER -> Severity.BLOCKER;
            case Common.ImpactSeverity.HIGH -> Severity.HIGH;
            case Common.ImpactSeverity.MEDIUM -> Severity.MEDIUM;
            case Common.ImpactSeverity.LOW -> Severity.LOW;
            case Common.ImpactSeverity.ImpactSeverity_INFO -> Severity.INFO;
            case Common.ImpactSeverity.UNKNOWN_IMPACT_SEVERITY -> throw new UnsupportedOperationException("Impact severity not supported");
        };
    }
}

