/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.platform;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.config.PropertyDefinitions;
import org.sonar.api.utils.System2;
import org.sonar.core.platform.ClassDerivedBeanDefinition;
import org.sonar.core.platform.ComponentKeys;
import org.sonar.core.platform.Container;
import org.sonar.core.platform.LazyUnlessStartableStrategy;
import org.sonar.core.platform.Module;
import org.sonar.core.platform.PluginInfo;
import org.sonar.core.platform.PriorityBeanFactory;
import org.sonar.core.platform.SpringInitStrategy;
import org.sonar.core.platform.StartableBeanPostProcessor;
import org.sonar.core.platform.StartableContainer;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class SpringComponentContainer
implements StartableContainer {
    protected final AnnotationConfigApplicationContext context;
    @Nullable
    protected final SpringComponentContainer parent;
    protected final List<SpringComponentContainer> children = new ArrayList<SpringComponentContainer>();
    private final Set<Class<?>> webConfigurationClasses = new HashSet();
    private final PropertyDefinitions propertyDefinitions;
    private final ComponentKeys componentKeys = new ComponentKeys();

    public SpringComponentContainer() {
        this(null, new PropertyDefinitions(System2.INSTANCE, new Object[0]), Collections.emptyList(), new LazyUnlessStartableStrategy());
    }

    protected SpringComponentContainer(List<?> externalExtensions) {
        this(null, new PropertyDefinitions(System2.INSTANCE, new Object[0]), externalExtensions, new LazyUnlessStartableStrategy());
    }

    protected SpringComponentContainer(SpringComponentContainer parent) {
        this(parent, parent.propertyDefinitions, Collections.emptyList(), new LazyUnlessStartableStrategy());
    }

    protected SpringComponentContainer(SpringComponentContainer parent, List<?> externalExtensions) {
        this(parent, parent.propertyDefinitions, externalExtensions, new LazyUnlessStartableStrategy());
    }

    protected SpringComponentContainer(SpringComponentContainer parent, SpringInitStrategy initStrategy) {
        this(parent, parent.propertyDefinitions, Collections.emptyList(), initStrategy);
    }

    protected SpringComponentContainer(@Nullable SpringComponentContainer parent, PropertyDefinitions propertyDefs, List<?> externalExtensions, SpringInitStrategy initStrategy) {
        this.parent = parent;
        this.propertyDefinitions = propertyDefs;
        this.context = new AnnotationConfigApplicationContext(new PriorityBeanFactory());
        this.context.setAllowBeanDefinitionOverriding(false);
        ((AbstractAutowireCapableBeanFactory)((Object)this.context.getBeanFactory())).setParameterNameDiscoverer(null);
        if (parent != null) {
            this.context.setParent(parent.context);
            parent.children.add(this);
        }
        this.add(initStrategy);
        this.add(this);
        this.add(new StartableBeanPostProcessor());
        this.add(externalExtensions);
        this.add(propertyDefs);
    }

    @Override
    public Container add(Object ... objects) {
        for (Object o : objects) {
            if (o instanceof Class) {
                Class clazz = (Class)o;
                if (Module.class.isAssignableFrom(clazz)) {
                    throw new IllegalStateException("Modules should be added as instances");
                }
                this.context.registerBean(this.componentKeys.ofClass(clazz), clazz, new BeanDefinitionCustomizer[0]);
                this.declareExtension("", o);
                continue;
            }
            if (o instanceof Module) {
                Module module = (Module)o;
                module.configure(this);
                continue;
            }
            if (o instanceof Iterable) {
                this.add(Iterables.toArray((Iterable)o, Object.class));
                continue;
            }
            this.registerInstance(o);
            this.declareExtension("", o);
        }
        return this;
    }

    @Override
    public void addWebApiV2ConfigurationClass(Class<?> clazz) {
        this.webConfigurationClasses.add(clazz);
    }

    @Override
    public Set<Class<?>> getWebApiV2ConfigurationClasses() {
        return Set.copyOf(this.webConfigurationClasses);
    }

    @Override
    public <T> T getParentComponentByType(Class<T> type) {
        if (this.parent == null) {
            throw new IllegalStateException("No parent container");
        }
        return this.parent.getComponentByType(type);
    }

    @Override
    public <T> List<T> getParentComponentsByType(Class<T> type) {
        if (this.parent == null) {
            throw new IllegalStateException("No parent container");
        }
        return this.parent.getComponentsByType(type);
    }

    private <T> void registerInstance(T instance) {
        Supplier<Object> supplier = () -> instance;
        Class<?> clazz = instance.getClass();
        this.context.registerBean(this.componentKeys.ofInstance(instance), clazz, supplier, new BeanDefinitionCustomizer[0]);
    }

    private Container addExtension(Object o) {
        if (o instanceof Class) {
            Class clazz = (Class)o;
            ClassDerivedBeanDefinition bd = new ClassDerivedBeanDefinition(clazz);
            this.context.registerBeanDefinition(this.componentKeys.ofClass(clazz), bd);
        } else if (o instanceof Iterable) {
            ((Iterable)o).forEach(this::addExtension);
        } else {
            this.registerInstance(o);
        }
        return this;
    }

    @Override
    public <T> T getComponentByType(Class<T> type) {
        try {
            return this.context.getBean(type);
        }
        catch (Exception t) {
            throw new IllegalStateException("Unable to load component " + String.valueOf(type), t);
        }
    }

    @Override
    public <T> Optional<T> getOptionalComponentByType(Class<T> type) {
        try {
            return Optional.of(this.context.getBean(type));
        }
        catch (NoSuchBeanDefinitionException t) {
            return Optional.empty();
        }
    }

    @Override
    public <T> List<T> getComponentsByType(Class<T> type) {
        try {
            return new ArrayList<T>(this.context.getBeansOfType(type).values());
        }
        catch (Exception t) {
            throw new IllegalStateException("Unable to load components " + String.valueOf(type), t);
        }
    }

    public AnnotationConfigApplicationContext context() {
        return this.context;
    }

    public void execute() {
        RuntimeException r = null;
        try {
            this.startComponents();
        }
        catch (RuntimeException e) {
            r = e;
        }
        finally {
            block13: {
                try {
                    this.stopComponents();
                }
                catch (RuntimeException e) {
                    if (r != null) break block13;
                    r = e;
                }
            }
        }
        if (r != null) {
            throw r;
        }
    }

    @Override
    public SpringComponentContainer startComponents() {
        this.doBeforeStart();
        this.context.refresh();
        this.doAfterStart();
        return this;
    }

    public SpringComponentContainer stopComponents() {
        try {
            this.stopChildren();
            if (this.context.isActive()) {
                this.context.close();
            }
        }
        finally {
            if (this.parent != null) {
                this.parent.children.remove(this);
            }
        }
        return this;
    }

    private void stopChildren() {
        Lists.reverse(new ArrayList<SpringComponentContainer>(this.children)).stream().filter(Objects::nonNull).forEach(SpringComponentContainer::stopComponents);
    }

    public SpringComponentContainer createChild() {
        return new SpringComponentContainer(this);
    }

    @Override
    @CheckForNull
    public SpringComponentContainer getParent() {
        return this.parent;
    }

    @Override
    public SpringComponentContainer addExtension(@Nullable PluginInfo pluginInfo, Object extension) {
        this.addExtension(extension);
        this.declareExtension(pluginInfo, extension);
        return this;
    }

    @Override
    public SpringComponentContainer addExtension(@Nullable String defaultCategory, Object extension) {
        this.addExtension(extension);
        this.declareExtension(defaultCategory, extension);
        return this;
    }

    @Override
    public SpringComponentContainer declareExtension(@Nullable PluginInfo pluginInfo, Object extension) {
        this.declareExtension(pluginInfo != null ? pluginInfo.getName() : "", extension);
        return this;
    }

    @Override
    public SpringComponentContainer declareExtension(@Nullable String defaultCategory, Object extension) {
        this.propertyDefinitions.addComponent(extension, Optional.ofNullable(defaultCategory).orElse(""));
        return this;
    }

    protected void doBeforeStart() {
    }

    protected void doAfterStart() {
    }
}

