/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.platform;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.api.server.ServerSide;
import org.sonar.classloader.ClassloaderBuilder;
import org.sonar.classloader.Mask;
import org.sonar.core.platform.PluginClassLoaderDef;

@ScannerSide
@ServerSide
@ComputeEngineSide
public class PluginClassloaderFactory {
    private static final String API_CLASSLOADER_KEY = "_api_";

    public Map<PluginClassLoaderDef, ClassLoader> create(Map<PluginClassLoaderDef, ClassLoader> previouslyCreatedClassloaders, Collection<PluginClassLoaderDef> newDefs) {
        ClassLoader baseClassLoader = this.baseClassLoader();
        HashSet<PluginClassLoaderDef> allDefs = new HashSet<PluginClassLoaderDef>();
        allDefs.addAll(newDefs);
        allDefs.addAll(previouslyCreatedClassloaders.keySet());
        ClassloaderBuilder builder = new ClassloaderBuilder(previouslyCreatedClassloaders.values());
        builder.newClassloader(API_CLASSLOADER_KEY, baseClassLoader);
        builder.setMask(API_CLASSLOADER_KEY, PluginClassloaderFactory.apiMask());
        for (PluginClassLoaderDef def : newDefs) {
            builder.newClassloader(def.getBasePluginKey());
            builder.setParent(def.getBasePluginKey(), API_CLASSLOADER_KEY, Mask.ALL);
            builder.setLoadingOrder(def.getBasePluginKey(), def.isSelfFirstStrategy() ? ClassloaderBuilder.LoadingOrder.SELF_FIRST : ClassloaderBuilder.LoadingOrder.PARENT_FIRST);
            for (File jar : def.getFiles()) {
                builder.addURL(def.getBasePluginKey(), PluginClassloaderFactory.fileToUrl(jar));
            }
            PluginClassloaderFactory.exportResources(def, builder, allDefs);
        }
        return PluginClassloaderFactory.build(newDefs, builder);
    }

    private static void exportResources(PluginClassLoaderDef newDef, ClassloaderBuilder builder, Collection<PluginClassLoaderDef> allPlugins) {
        builder.setExportMask(newDef.getBasePluginKey(), newDef.getExportMask().build());
        for (PluginClassLoaderDef other : allPlugins) {
            if (other.getBasePluginKey().equals(newDef.getBasePluginKey())) continue;
            builder.addSibling(newDef.getBasePluginKey(), other.getBasePluginKey(), Mask.ALL);
        }
    }

    private static Map<PluginClassLoaderDef, ClassLoader> build(Collection<PluginClassLoaderDef> defs, ClassloaderBuilder builder) {
        HashMap<PluginClassLoaderDef, ClassLoader> result = new HashMap<PluginClassLoaderDef, ClassLoader>();
        Map<String, ClassLoader> classloadersByBasePluginKey = builder.build();
        for (PluginClassLoaderDef def : defs) {
            ClassLoader classloader = classloadersByBasePluginKey.get(def.getBasePluginKey());
            if (classloader == null) {
                throw new IllegalStateException(String.format("Fail to create classloader for plugin [%s]", def.getBasePluginKey()));
            }
            result.put(def, classloader);
        }
        return result;
    }

    ClassLoader baseClassLoader() {
        return this.getClass().getClassLoader();
    }

    private static URL fileToUrl(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static Mask apiMask() {
        return Mask.builder().include("org/sonar/api/", "org/sonar/check/", "org/codehaus/stax2/", "org/codehaus/staxmate/", "com/ctc/wstx/", "org/slf4j/", "org/apache/commons/logging/", "org/apache/log4j/", "ch/qos/logback/", "javax/servlet/", "org/sonar/server/platform/", "com/sonarsource/plugins/license/api/").exclude("org/sonar/api/internal/", new String[0]).build();
    }
}

