/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.platform;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.io.Closeable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.LoggerFactory;
import org.sonar.api.Plugin;
import org.sonar.core.platform.ExplodedPlugin;
import org.sonar.core.platform.PluginClassLoaderDef;
import org.sonar.core.platform.PluginClassloaderFactory;
import org.sonar.core.platform.PluginInfo;
import org.sonar.updatecenter.common.Version;

public class PluginClassLoader {
    private static final String[] DEFAULT_SHARED_RESOURCES = new String[]{"org/sonar/plugins", "com/sonar/plugins", "com/sonarsource/plugins"};
    private static final Version COMPATIBILITY_MODE_MAX_VERSION = Version.create("5.2");
    private final PluginClassloaderFactory classloaderFactory;
    private final Map<PluginClassLoaderDef, ClassLoader> classLoaders = new HashMap<PluginClassLoaderDef, ClassLoader>();

    public PluginClassLoader(PluginClassloaderFactory classloaderFactory) {
        this.classloaderFactory = classloaderFactory;
    }

    public Map<String, Plugin> load(Collection<ExplodedPlugin> plugins) {
        return this.load(plugins.stream().collect(Collectors.toMap(ExplodedPlugin::getKey, x -> x)));
    }

    public Map<String, Plugin> load(Map<String, ExplodedPlugin> pluginsByKey) {
        Collection<PluginClassLoaderDef> defs = this.defineClassloaders(pluginsByKey);
        Map<PluginClassLoaderDef, ClassLoader> newClassloaders = this.classloaderFactory.create(this.classLoaders, defs);
        this.classLoaders.putAll(newClassloaders);
        return PluginClassLoader.instantiatePluginClasses(newClassloaders);
    }

    @VisibleForTesting
    Collection<PluginClassLoaderDef> defineClassloaders(Map<String, ExplodedPlugin> pluginsByKey) {
        HashMap<String, PluginClassLoaderDef> classloadersByBasePlugin = new HashMap<String, PluginClassLoaderDef>();
        for (ExplodedPlugin plugin : pluginsByKey.values()) {
            PluginInfo info = plugin.getPluginInfo();
            String baseKey = PluginClassLoader.basePluginKey(info, pluginsByKey);
            PluginClassLoaderDef def = (PluginClassLoaderDef)classloadersByBasePlugin.get(baseKey);
            if (def == null) {
                def = new PluginClassLoaderDef(baseKey);
                classloadersByBasePlugin.put(baseKey, def);
            }
            def.addFiles(Collections.singleton(plugin.getMain()));
            def.addFiles(plugin.getLibs());
            def.addMainClass(info.getKey(), info.getMainClass());
            for (String defaultSharedResource : DEFAULT_SHARED_RESOURCES) {
                def.getExportMask().include(String.format("%s/%s/api/", defaultSharedResource, info.getKey()), new String[0]);
            }
            if (!Strings.isNullOrEmpty(info.getBasePlugin())) continue;
            if (info.isUseChildFirstClassLoader()) {
                LoggerFactory.getLogger(this.getClass()).warn("Plugin {} [{}] uses a child first classloader which is deprecated", (Object)info.getName(), (Object)info.getKey());
            }
            def.setSelfFirstStrategy(info.isUseChildFirstClassLoader());
            Version minSonarPluginApiVersion = info.getMinimalSonarPluginApiVersion();
            boolean compatibilityMode = minSonarPluginApiVersion != null && minSonarPluginApiVersion.compareToIgnoreQualifier(COMPATIBILITY_MODE_MAX_VERSION) < 0;
            if (!compatibilityMode) continue;
            LoggerFactory.getLogger(this.getClass()).warn("API compatibility mode is no longer supported. In case of error, plugin {} [{}] should package its dependencies.", (Object)info.getName(), (Object)info.getKey());
        }
        return classloadersByBasePlugin.values();
    }

    private static Map<String, Plugin> instantiatePluginClasses(Map<PluginClassLoaderDef, ClassLoader> classloaders) {
        HashMap<String, Plugin> instancesByPluginKey = new HashMap<String, Plugin>();
        for (Map.Entry<PluginClassLoaderDef, ClassLoader> entry : classloaders.entrySet()) {
            PluginClassLoaderDef def = entry.getKey();
            ClassLoader classLoader = entry.getValue();
            for (Map.Entry<String, String> mainClassEntry : def.getMainClassesByPluginKey().entrySet()) {
                String pluginKey = mainClassEntry.getKey();
                String mainClass = mainClassEntry.getValue();
                try {
                    instancesByPluginKey.put(pluginKey, (Plugin)classLoader.loadClass(mainClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (UnsupportedClassVersionError e) {
                    throw new IllegalStateException(String.format("The plugin [%s] does not support Java %s", pluginKey, SystemUtils.JAVA_VERSION), e);
                }
                catch (Throwable e) {
                    throw new IllegalStateException(String.format("Fail to instantiate class [%s] of plugin [%s]", mainClass, pluginKey), e);
                }
            }
        }
        return instancesByPluginKey;
    }

    public void unload(Collection<Plugin> plugins) {
        for (Plugin plugin : plugins) {
            ClassLoader classLoader = plugin.getClass().getClassLoader();
            if (!(classLoader instanceof Closeable)) continue;
            Closeable closeable = (Closeable)((Object)classLoader);
            if (classLoader == this.classloaderFactory.baseClassLoader()) continue;
            try {
                closeable.close();
            }
            catch (Exception e) {
                LoggerFactory.getLogger(this.getClass()).error("Fail to close classloader " + classLoader.toString(), e);
            }
        }
    }

    private static String basePluginKey(PluginInfo plugin, Map<String, ExplodedPlugin> pluginsByKey) {
        String base = plugin.getKey();
        String parentKey = plugin.getBasePlugin();
        while (!Strings.isNullOrEmpty(parentKey)) {
            PluginInfo parentPlugin = pluginsByKey.get(parentKey).getPluginInfo();
            base = parentPlugin.getKey();
            parentKey = parentPlugin.getBasePlugin();
        }
        return base;
    }
}

