/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.metric;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Metric;
import org.sonar.api.measures.Metrics;
import org.sonar.api.scanner.ScannerSide;
import org.springframework.beans.factory.annotation.Autowired;

@ComputeEngineSide
@ScannerSide
public class ScannerMetrics {
    private static final Set<Metric> ALLOWED_CORE_METRICS = Set.of(CoreMetrics.GENERATED_LINES, CoreMetrics.NCLOC, CoreMetrics.NCLOC_DATA, CoreMetrics.GENERATED_NCLOC, CoreMetrics.COMMENT_LINES, CoreMetrics.PUBLIC_API, CoreMetrics.PUBLIC_UNDOCUMENTED_API, CoreMetrics.CLASSES, CoreMetrics.FUNCTIONS, CoreMetrics.STATEMENTS, CoreMetrics.COMPLEXITY, CoreMetrics.COGNITIVE_COMPLEXITY, CoreMetrics.TESTS, CoreMetrics.SKIPPED_TESTS, CoreMetrics.TEST_ERRORS, CoreMetrics.TEST_FAILURES, CoreMetrics.TEST_EXECUTION_TIME, CoreMetrics.EXECUTABLE_LINES_DATA);
    private Set<Metric> metrics = ALLOWED_CORE_METRICS;

    @Autowired(required=false)
    public ScannerMetrics() {
    }

    @Autowired(required=false)
    public ScannerMetrics(List<Metrics> metricsRepositories) {
        this.addPluginMetrics(metricsRepositories);
    }

    public Set<Metric> getMetrics() {
        return this.metrics;
    }

    public void addPluginMetrics(List<Metrics> metricsRepositories) {
        this.metrics = Stream.concat(ScannerMetrics.getPluginMetrics(metricsRepositories.stream()), this.metrics.stream()).collect(Collectors.toSet());
    }

    private static Stream<Metric> getPluginMetrics(Stream<Metrics> metricsStream) {
        return metricsStream.map(Metrics::getMetrics).filter(Objects::nonNull).flatMap(Collection::stream);
    }
}

