/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.issue;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

public class IssueChangeContext
implements Serializable {
    private final String userUuid;
    private final Date date;
    private final boolean scan;
    private final boolean refreshMeasures;
    private final String externalUser;
    private final String webhookSource;

    private IssueChangeContext(Date date, boolean scan, boolean refreshMeasures, @Nullable String userUuid, @Nullable String externalUser, @Nullable String webhookSource) {
        this.userUuid = userUuid;
        this.date = Objects.requireNonNull(date);
        this.scan = scan;
        this.refreshMeasures = refreshMeasures;
        this.externalUser = externalUser;
        this.webhookSource = webhookSource;
    }

    @CheckForNull
    public String userUuid() {
        return this.userUuid;
    }

    public Date date() {
        return this.date;
    }

    public boolean scan() {
        return this.scan;
    }

    public boolean refreshMeasures() {
        return this.refreshMeasures;
    }

    @Nullable
    public String getExternalUser() {
        return this.externalUser;
    }

    @Nullable
    public String getWebhookSource() {
        return this.webhookSource;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IssueChangeContext that = (IssueChangeContext)o;
        return this.scan == that.scan && this.refreshMeasures == that.refreshMeasures && Objects.equals(this.userUuid, that.userUuid) && this.date.equals(that.date) && Objects.equals(this.externalUser, that.getExternalUser()) && Objects.equals(this.webhookSource, that.getWebhookSource());
    }

    public int hashCode() {
        return Objects.hash(this.userUuid, this.date, this.scan, this.refreshMeasures, this.externalUser, this.webhookSource);
    }

    public static IssueChangeContextBuilder newBuilder() {
        return new IssueChangeContextBuilder();
    }

    public static IssueChangeContextBuilder issueChangeContextByScanBuilder(Date date) {
        return IssueChangeContext.newBuilder().withScan().setUserUuid(null).setDate(date);
    }

    public static IssueChangeContextBuilder issueChangeContextByUserBuilder(Date date, @Nullable String userUuid) {
        return IssueChangeContext.newBuilder().setUserUuid(userUuid).setDate(date);
    }

    public static final class IssueChangeContextBuilder {
        private String userUuid;
        private Date date;
        private boolean scan = false;
        private boolean refreshMeasures = false;
        private String externalUser;
        private String webhookSource;

        private IssueChangeContextBuilder() {
        }

        public IssueChangeContextBuilder setUserUuid(@Nullable String userUuid) {
            this.userUuid = userUuid;
            return this;
        }

        public IssueChangeContextBuilder setDate(Date date) {
            this.date = date;
            return this;
        }

        public IssueChangeContextBuilder withScan() {
            this.scan = true;
            return this;
        }

        public IssueChangeContextBuilder withRefreshMeasures() {
            this.refreshMeasures = true;
            return this;
        }

        public IssueChangeContextBuilder setExternalUser(@Nullable String externalUser) {
            this.externalUser = externalUser;
            return this;
        }

        public IssueChangeContextBuilder setWebhookSource(@Nullable String webhookSource) {
            this.webhookSource = webhookSource;
            return this;
        }

        public IssueChangeContext build() {
            return new IssueChangeContext(this.date, this.scan, this.refreshMeasures, this.userUuid, this.externalUser, this.webhookSource);
        }
    }
}

