/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.extension;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.sonar.api.utils.AnnotationUtils;
import org.sonar.core.extension.PlatformLevel;

public final class PlatformLevelPredicates {
    private PlatformLevelPredicates() {
    }

    public static Predicate<Object> hasPlatformLevel(int i2) {
        PlatformLevelPredicates.checkSupportedLevel(i2, null);
        return o -> {
            PlatformLevel platformLevel = AnnotationUtils.getAnnotation(o, PlatformLevel.class);
            return platformLevel != null && PlatformLevelPredicates.checkSupportedLevel(platformLevel.value(), o) == i2;
        };
    }

    private static int checkSupportedLevel(int i2, @Nullable Object annotatedObject) {
        boolean supported;
        boolean bl = supported = i2 >= 1 && i2 <= 4;
        if (supported) {
            return i2;
        }
        throw new IllegalArgumentException(PlatformLevelPredicates.buildErrorMsgFrom(annotatedObject));
    }

    private static String buildErrorMsgFrom(@Nullable Object annotatedObject) {
        String baseErrorMsg = "Only level 1, 2, 3 and 4 are supported";
        if (annotatedObject == null) {
            return baseErrorMsg;
        }
        if (annotatedObject instanceof Class) {
            Class classAnnotatedObject = (Class)annotatedObject;
            return String.format("Invalid value for annotation %s on class '%s'. %s", PlatformLevel.class.getName(), classAnnotatedObject.getName(), baseErrorMsg);
        }
        return String.format("Invalid value for annotation %s on object of type %s. %s", PlatformLevel.class.getName(), annotatedObject.getClass().getName(), baseErrorMsg);
    }

    public static Predicate<Object> hasPlatformLevel4OrNone() {
        return o -> {
            PlatformLevel platformLevel = AnnotationUtils.getAnnotation(o, PlatformLevel.class);
            return platformLevel == null || PlatformLevelPredicates.checkSupportedLevel(platformLevel.value(), o) == 4;
        };
    }
}

