/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.extension;

import com.google.common.base.Preconditions;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.core.extension.CoreExtension;
import org.sonar.core.extension.CoreExtensionRepository;
import org.sonar.core.extension.ServiceLoaderWrapper;

public class CoreExtensionsLoader {
    private static final Logger LOG = LoggerFactory.getLogger(CoreExtensionsLoader.class);
    private final CoreExtensionRepository coreExtensionRepository;
    private final ServiceLoaderWrapper serviceLoaderWrapper;

    @Inject
    public CoreExtensionsLoader(CoreExtensionRepository coreExtensionRepository) {
        this(coreExtensionRepository, new ServiceLoaderWrapper());
    }

    CoreExtensionsLoader(CoreExtensionRepository coreExtensionRepository, ServiceLoaderWrapper serviceLoaderWrapper) {
        this.coreExtensionRepository = coreExtensionRepository;
        this.serviceLoaderWrapper = serviceLoaderWrapper;
    }

    public void load() {
        Set<CoreExtension> coreExtensions = this.serviceLoaderWrapper.load(this.getClass().getClassLoader());
        CoreExtensionsLoader.ensureNoDuplicateName(coreExtensions);
        this.coreExtensionRepository.setLoadedCoreExtensions(coreExtensions);
        if (!coreExtensions.isEmpty()) {
            LOG.atInfo().addArgument(coreExtensions.stream().map(CoreExtension::getName).collect(Collectors.joining(", "))).log("Loaded core extensions: {}");
        }
    }

    private static void ensureNoDuplicateName(Set<CoreExtension> coreExtensions) {
        Map<String, Long> nameCounts = coreExtensions.stream().map(CoreExtension::getName).collect(Collectors.groupingBy(t -> t, Collectors.counting()));
        Set duplicatedNames = nameCounts.entrySet().stream().filter(t -> (Long)t.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toSet());
        Preconditions.checkState(duplicatedNames.isEmpty(), "Multiple core extensions declare the following names: %s", (Object)(duplicatedNames.isEmpty() ? "" : duplicatedNames.stream().sorted().collect(Collectors.joining(", "))));
    }
}

