/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.documentation;

import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.api.config.Configuration;
import org.sonar.core.documentation.DocumentationBaseLinkProvider;
import org.sonar.core.documentation.DocumentationLinkGenerator;

public class DefaultDocumentationLinkGenerator
implements DocumentationLinkGenerator {
    public static final String DOCUMENTATION_PUBLIC_URL = "https://docs.sonarsource.com/sonarqube-community-build";
    private final String documentationBaseUrl;

    public DefaultDocumentationLinkGenerator(Configuration configuration, @Nullable DocumentationBaseLinkProvider documentationBaseLinkProvider) {
        this.documentationBaseUrl = configuration.get("sonar.documentation.baseUrl").or(() -> Optional.ofNullable(documentationBaseLinkProvider).map(DocumentationBaseLinkProvider::getDocumentationBaseUrl)).map(url -> url.endsWith("/") ? url.substring(0, url.lastIndexOf("/")) : url).orElse(DOCUMENTATION_PUBLIC_URL);
    }

    @Override
    public String getDocumentationLink(@Nullable String suffix) {
        return this.documentationBaseUrl + Optional.ofNullable(suffix).orElse("");
    }
}

