/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.config;

import java.util.Arrays;
import java.util.List;
import org.sonar.api.PropertyType;
import org.sonar.api.config.PropertyDefinition;

public class ScannerProperties {
    public static final String BRANCHES_DOC_LINK_SUFFIX = "/analyzing-source-code/analysis-parameters/#multibranch";
    public static final String BRANCH_NAME = "sonar.branch.name";
    public static final String PULL_REQUEST_KEY = "sonar.pullrequest.key";
    public static final String PULL_REQUEST_BRANCH = "sonar.pullrequest.branch";
    public static final String PULL_REQUEST_BASE = "sonar.pullrequest.base";
    public static final String FILE_SIZE_LIMIT = "sonar.filesize.limit";
    public static final String LINKS_SOURCES_DEV = "sonar.links.scm_dev";
    public static final String DISABLE_PROJECT_AND_ORG_AUTODETECTION = "sonar.keys_autodetection.disabled";
    public static final String PLUGIN_LOADING_OPTIMIZATION_KEY = "sonar.plugins.downloadOnlyRequired";

    private ScannerProperties() {
    }

    public static List<PropertyDefinition> all() {
        return Arrays.asList(PropertyDefinition.builder("sonar.scm.disabled").name("Disable the SCM Sensor").description("Disable the retrieval of blame information from Source Control Manager").category("scm").type(PropertyType.BOOLEAN).onConfigScopes(PropertyDefinition.ConfigScope.PROJECT, new PropertyDefinition.ConfigScope[0]).defaultValue(String.valueOf(false)).build(), PropertyDefinition.builder("sonar.scm.provider").name("Key of the SCM provider for this project").description("Force the provider to be used to get SCM information for this project. By default auto-detection is done. Example: svn, git.").category("scm").onlyOnConfigScopes(PropertyDefinition.ConfigScope.PROJECT, new PropertyDefinition.ConfigScope[0]).build(), PropertyDefinition.builder(BRANCH_NAME).name("Optional name of SonarQube/SCM branch").description("Provide a name for the branch being analyzed. It might match an existing branch of the project, otherwise a new branch will be created.").hidden().build(), PropertyDefinition.builder(PULL_REQUEST_BRANCH).name("Optional name of pull request").description("Provide a name for the pull request being analyzed. It might match an existing pull request of the project, otherwise a new pull request will be created.").hidden().build(), PropertyDefinition.builder(PULL_REQUEST_BASE).name("Optional name of target branch to merge into").description("Defines the target branch of the pull request being analyzed. If no target is defined, the main branch is used as the target.").hidden().build(), PropertyDefinition.builder(DISABLE_PROJECT_AND_ORG_AUTODETECTION).name("Disables project auto-detection").description("Disables auto-detection of project keys from scanner execution environment.").type(PropertyType.BOOLEAN).hidden().build(), PropertyDefinition.builder(FILE_SIZE_LIMIT).name("Limit of a file size excluded from analysis in MB").type(PropertyType.INTEGER).defaultValue("20").description("Allows discarding files from analysis exceeding certain sizes.").hidden().build(), PropertyDefinition.builder(PLUGIN_LOADING_OPTIMIZATION_KEY).name("Analyzers loading optimization").description("When enabled, scanners will only download analyzers required for detected languages.").category("general").subCategory("Performance").type(PropertyType.BOOLEAN).defaultValue("true").build());
    }
}

