/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.config;

import java.util.Map;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum MaxTokenLifetimeOption {
    THIRTY_DAYS("30 days", 30),
    NINETY_DAYS("90 days", 90),
    ONE_YEAR("1 year", 365),
    NO_EXPIRATION("No expiration");

    private static final Map<String, MaxTokenLifetimeOption> INTERVALS_MAP;
    private final String name;
    private final Integer days;

    private MaxTokenLifetimeOption(String name) {
        this.name = name;
        this.days = null;
    }

    private MaxTokenLifetimeOption(String name, Integer days) {
        this.name = name;
        this.days = days;
    }

    public String getName() {
        return this.name;
    }

    public Optional<Integer> getDays() {
        return Optional.ofNullable(this.days);
    }

    public static MaxTokenLifetimeOption get(String name) {
        return Optional.ofNullable(INTERVALS_MAP.get(name)).orElseThrow(() -> new IllegalArgumentException("No token expiration interval with name \"" + name + "\" found."));
    }

    static {
        INTERVALS_MAP = Stream.of(MaxTokenLifetimeOption.values()).collect(Collectors.toMap(MaxTokenLifetimeOption::getName, UnaryOperator.identity()));
    }
}

