/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.classloader;

import java.net.URL;
import java.util.Collection;
import org.sonar.classloader.Strategy;
import org.sonar.classloader.StrategyContext;

class SelfFirstStrategy
implements Strategy {
    static final SelfFirstStrategy INSTANCE = new SelfFirstStrategy();

    private SelfFirstStrategy() {
    }

    @Override
    public Class loadClass(StrategyContext context, String name) throws ClassNotFoundException {
        Class clazz = context.loadClassFromSiblings(name);
        if (clazz == null && (clazz = context.loadClassFromSelf(name)) == null && (clazz = context.loadClassFromParent(name)) == null) {
            throw new ClassNotFoundException(name);
        }
        return clazz;
    }

    @Override
    public URL getResource(StrategyContext context, String name) {
        URL url = context.loadResourceFromSiblings(name);
        if (url == null && (url = context.loadResourceFromSelf(name)) == null) {
            url = context.loadResourceFromParent(name);
        }
        return url;
    }

    @Override
    public void getResources(StrategyContext context, String name, Collection<URL> appendTo) {
        context.loadResourcesFromSiblings(name, appendTo);
        context.loadResourcesFromSelf(name, appendTo);
        context.loadResourcesFromParent(name, appendTo);
    }
}

