/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.classloader;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;

public class Mask {
    private static final String ROOT = "/";
    public static final Mask ALL = Mask.builder().build();
    public static final Mask NONE = Mask.builder().exclude("/", new String[0]).build();
    private final Set<String> inclusions;
    private final Set<String> exclusions;

    private Mask(Builder builder) {
        this.inclusions = Collections.unmodifiableSet(builder.inclusions);
        this.exclusions = Collections.unmodifiableSet(builder.exclusions);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Set<String> getInclusions() {
        return this.inclusions;
    }

    public Set<String> getExclusions() {
        return this.exclusions;
    }

    boolean acceptClass(String classname) {
        if (this.inclusions.isEmpty() && this.exclusions.isEmpty()) {
            return true;
        }
        return this.acceptResource(Mask.classToResource(classname));
    }

    boolean acceptResource(String name) {
        boolean ok = true;
        if (!this.inclusions.isEmpty()) {
            ok = false;
            for (String include : this.inclusions) {
                if (!Mask.matchPattern(name, include)) continue;
                ok = true;
                break;
            }
        }
        if (ok) {
            for (String exclude : this.exclusions) {
                if (!Mask.matchPattern(name, exclude)) continue;
                ok = false;
                break;
            }
        }
        return ok;
    }

    private static boolean matchPattern(String name, String pattern) {
        return pattern.equals(ROOT) || pattern.endsWith(ROOT) && name.startsWith(pattern) || pattern.equals(name);
    }

    private static String classToResource(String classname) {
        return classname.replace('.', '/') + ".class";
    }

    public static class Builder {
        private final Set<String> inclusions = new HashSet<String>();
        private final Set<String> exclusions = new HashSet<String>();

        private Builder() {
        }

        public Builder include(String path, String ... others) {
            this.doInclude(path);
            for (String other : others) {
                this.doInclude(other);
            }
            return this;
        }

        public Builder exclude(String path, String ... others) {
            this.doExclude(path);
            for (String other : others) {
                this.doExclude(other);
            }
            return this;
        }

        public Builder copy(Mask with) {
            this.inclusions.addAll(with.inclusions);
            this.exclusions.addAll(with.exclusions);
            return this;
        }

        public Builder merge(Mask with) {
            ArrayList<String> lowestIncludes = new ArrayList<String>();
            if (this.inclusions.isEmpty()) {
                lowestIncludes.addAll(with.inclusions);
            } else if (with.inclusions.isEmpty()) {
                lowestIncludes.addAll(this.inclusions);
            } else {
                for (String include : this.inclusions) {
                    for (String fromInclude : with.inclusions) {
                        if (!fromInclude.startsWith(include)) continue;
                        lowestIncludes.add(fromInclude);
                    }
                }
                for (String fromInclude : with.inclusions) {
                    for (String include : this.inclusions) {
                        if (!include.startsWith(fromInclude)) continue;
                        lowestIncludes.add(include);
                    }
                }
            }
            this.inclusions.clear();
            this.inclusions.addAll(lowestIncludes);
            this.exclusions.addAll(with.exclusions);
            return this;
        }

        public Mask build() {
            return new Mask(this);
        }

        private void doInclude(@Nullable String path) {
            this.inclusions.add(Builder.validatePath(path));
        }

        private void doExclude(@Nullable String path) {
            this.exclusions.add(Builder.validatePath(path));
        }

        private static String validatePath(@Nullable String path) {
            if (path == null) {
                throw new IllegalArgumentException("Mask path must not be null");
            }
            if (path.startsWith(Mask.ROOT) && path.length() > 1) {
                throw new IllegalArgumentException("Mask path must not start with slash: ");
            }
            if (path.contains("*")) {
                throw new IllegalArgumentException("Mask path is not a wildcard pattern and should not contain star characters (*): " + path);
            }
            return path;
        }
    }
}

