/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.classloader;

import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sonar.classloader.ClassRealm;
import org.sonar.classloader.DefaultClassloaderRef;
import org.sonar.classloader.Mask;
import org.sonar.classloader.ParentFirstStrategy;
import org.sonar.classloader.SelfFirstStrategy;
import org.sonar.classloader.Strategy;

public class ClassloaderBuilder {
    private final Map<String, ClassRealm> previouslyCreatedClassLoaders;
    private final Map<String, NewRealm> newRealmsByKey = new HashMap<String, NewRealm>();

    public ClassloaderBuilder() {
        this(Collections.emptyList());
    }

    public ClassloaderBuilder(Collection<ClassLoader> previouslyCreatedClassLoaders) {
        this.previouslyCreatedClassLoaders = new HashMap<String, ClassRealm>();
        for (ClassLoader cl : previouslyCreatedClassLoaders) {
            if (!(cl instanceof ClassRealm)) {
                throw new IllegalArgumentException("classloader not of type ClassRealm: " + cl);
            }
            ClassRealm classRealm = (ClassRealm)cl;
            this.previouslyCreatedClassLoaders.put(classRealm.getKey(), classRealm);
        }
    }

    public ClassloaderBuilder newClassloader(String key) {
        return this.newClassloader(key, ClassloaderBuilder.getSystemClassloader());
    }

    public ClassloaderBuilder newClassloader(final String key, final ClassLoader baseClassloader) {
        if (this.newRealmsByKey.containsKey(key)) {
            throw new IllegalStateException(String.format("The classloader '%s' already exists. Can not create it twice.", key));
        }
        if (this.previouslyCreatedClassLoaders.containsKey(key)) {
            throw new IllegalStateException(String.format("The classloader '%s' already exists in the list of previously created classloaders. Can not create it twice.", key));
        }
        ClassRealm realm = AccessController.doPrivileged(new PrivilegedAction<ClassRealm>(){

            @Override
            public ClassRealm run() {
                return new ClassRealm(key, baseClassloader);
            }
        });
        realm.setStrategy(LoadingOrder.PARENT_FIRST.strategy);
        this.newRealmsByKey.put(key, new NewRealm(realm));
        return this;
    }

    public ClassloaderBuilder setParent(String key, String parentKey, Mask mask) {
        NewRealm newRealm = this.getOrFail(key);
        newRealm.parentKey = parentKey;
        newRealm.associatedMasks.put(parentKey, mask);
        return this;
    }

    public ClassloaderBuilder setParent(String key, ClassLoader parent, Mask mask) {
        NewRealm newRealm = this.getOrFail(key);
        newRealm.realm.setParent(new DefaultClassloaderRef(parent, mask));
        return this;
    }

    public ClassloaderBuilder addSibling(String key, String siblingKey, Mask mask) {
        NewRealm newRealm = this.getOrFail(key);
        newRealm.siblingKeys.add(siblingKey);
        newRealm.associatedMasks.put(siblingKey, mask);
        return this;
    }

    public ClassloaderBuilder addSibling(String key, ClassLoader sibling, Mask mask) {
        NewRealm newRealm = this.getOrFail(key);
        newRealm.realm.addSibling(new DefaultClassloaderRef(sibling, mask));
        return this;
    }

    public ClassloaderBuilder addURL(String key, URL url) {
        this.getOrFail(key).realm.addConstituent(url);
        return this;
    }

    public ClassloaderBuilder setMask(String key, Mask mask) {
        this.getOrFail(key).realm.setMask(mask);
        return this;
    }

    public ClassloaderBuilder setExportMask(String key, Mask mask) {
        this.getOrFail(key).realm.setExportMask(mask);
        return this;
    }

    public ClassloaderBuilder setLoadingOrder(String key, LoadingOrder order) {
        this.getOrFail(key).realm.setStrategy(order.strategy);
        return this;
    }

    public Map<String, ClassLoader> build() {
        HashMap<String, ClassLoader> result = new HashMap<String, ClassLoader>();
        for (Map.Entry<String, NewRealm> entry : this.newRealmsByKey.entrySet()) {
            NewRealm newRealm = entry.getValue();
            if (newRealm.parentKey != null) {
                ClassRealm parent = this.getNewOrPreviousClassloader(newRealm.parentKey);
                Mask parentMask = (Mask)newRealm.associatedMasks.get(newRealm.parentKey);
                parentMask = this.mergeWithExportMask(parentMask, newRealm.parentKey);
                newRealm.realm.setParent(new DefaultClassloaderRef(parent, parentMask));
            }
            for (String siblingKey : newRealm.siblingKeys) {
                ClassRealm sibling = this.getNewOrPreviousClassloader(siblingKey);
                Mask siblingMask = (Mask)newRealm.associatedMasks.get(siblingKey);
                siblingMask = this.mergeWithExportMask(siblingMask, siblingKey);
                newRealm.realm.addSibling(new DefaultClassloaderRef(sibling, siblingMask));
            }
            result.put(newRealm.realm.getKey(), newRealm.realm);
        }
        return result;
    }

    private Mask mergeWithExportMask(Mask mask, String exportKey) {
        NewRealm newRealm = this.newRealmsByKey.get(exportKey);
        if (newRealm != null) {
            return Mask.builder().copy(mask).merge(newRealm.realm.getExportMask()).build();
        }
        ClassRealm realm = this.previouslyCreatedClassLoaders.get(exportKey);
        if (realm != null) {
            return Mask.builder().copy(mask).merge(realm.getExportMask()).build();
        }
        return mask;
    }

    private NewRealm getOrFail(String key) {
        NewRealm newRealm = this.newRealmsByKey.get(key);
        if (newRealm == null) {
            throw new IllegalStateException(String.format("The classloader '%s' does not exist", key));
        }
        return newRealm;
    }

    private ClassRealm getNewOrPreviousClassloader(String key) {
        NewRealm newRealm = this.newRealmsByKey.get(key);
        if (newRealm != null) {
            return newRealm.realm;
        }
        ClassRealm previousClassloader = this.previouslyCreatedClassLoaders.get(key);
        if (previousClassloader != null) {
            return previousClassloader;
        }
        throw new IllegalStateException(String.format("The classloader '%s' does not exist", key));
    }

    private static ClassLoader getSystemClassloader() {
        ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
        ClassLoader systemParent = systemClassLoader.getParent();
        if (systemParent != null) {
            systemClassLoader = systemParent;
        }
        return systemClassLoader;
    }

    public static enum LoadingOrder {
        PARENT_FIRST(ParentFirstStrategy.INSTANCE),
        SELF_FIRST(SelfFirstStrategy.INSTANCE);

        private final Strategy strategy;

        private LoadingOrder(Strategy strategy) {
            this.strategy = strategy;
        }
    }

    private static class NewRealm {
        private final ClassRealm realm;
        private String parentKey;
        private final List<String> siblingKeys = new ArrayList<String>();
        private final Map<String, Mask> associatedMasks = new HashMap<String, Mask>();

        private NewRealm(ClassRealm realm) {
            this.realm = realm;
        }
    }
}

