/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.classloader;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.classloader.ClassloaderRef;
import org.sonar.classloader.Mask;
import org.sonar.classloader.NullClassloaderRef;
import org.sonar.classloader.Strategy;
import org.sonar.classloader.StrategyContext;

class ClassRealm
extends URLClassLoader
implements StrategyContext {
    private final String key;
    private Mask mask = Mask.ALL;
    private Mask exportMask = Mask.ALL;
    private ClassloaderRef parentRef = NullClassloaderRef.INSTANCE;
    private List<ClassloaderRef> siblingRefs = new ArrayList<ClassloaderRef>();
    private Strategy strategy;

    ClassRealm(String key, ClassLoader baseClassloader) {
        super(new URL[0], baseClassloader);
        this.key = key;
    }

    String getKey() {
        return this.key;
    }

    ClassRealm setMask(Mask mask) {
        this.mask = mask;
        return this;
    }

    Mask getExportMask() {
        return this.exportMask;
    }

    ClassRealm setExportMask(Mask exportMask) {
        this.exportMask = exportMask;
        return this;
    }

    ClassRealm setParent(ClassloaderRef parentRef) {
        this.parentRef = parentRef;
        return this;
    }

    ClassRealm addSibling(ClassloaderRef ref) {
        this.siblingRefs.add(ref);
        return this;
    }

    ClassRealm setStrategy(Strategy strategy) {
        this.strategy = strategy;
        return this;
    }

    ClassRealm addConstituent(URL url) {
        super.addURL(url);
        return this;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (this.mask.acceptClass(name)) {
            try {
                return super.loadClass(name, resolve);
            }
            catch (ClassNotFoundException ignored) {
                return this.strategy.loadClass(this, name);
            }
        }
        throw new ClassNotFoundException(String.format("Class %s is not accepted in classloader %s", name, this));
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        throw new ClassNotFoundException(name);
    }

    @Override
    @CheckForNull
    public URL getResource(String name) {
        if (this.mask.acceptResource(name)) {
            return this.strategy.getResource(this, name);
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        ArrayList<URL> resources = new ArrayList<URL>();
        if (this.mask.acceptResource(name)) {
            this.strategy.getResources(this, name, resources);
        }
        return Collections.enumeration(resources);
    }

    @Override
    public Class loadClassFromSelf(String name) {
        Class<?> clazz = this.findLoadedClass(name);
        if (clazz == null) {
            try {
                return super.findClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return clazz;
    }

    @Override
    public Class loadClassFromSiblings(String name) {
        for (ClassloaderRef siblingRef : this.siblingRefs) {
            Class clazz = siblingRef.loadClassIfPresent(name);
            if (clazz == null) continue;
            return clazz;
        }
        return null;
    }

    @Override
    public Class loadClassFromParent(String name) {
        return this.parentRef.loadClassIfPresent(name);
    }

    @Override
    public URL loadResourceFromSelf(String name) {
        return super.findResource(name);
    }

    @Override
    public URL loadResourceFromSiblings(String name) {
        for (ClassloaderRef siblingRef : this.siblingRefs) {
            URL url = siblingRef.loadResourceIfPresent(name);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    @Override
    public URL loadResourceFromParent(String name) {
        return this.parentRef.loadResourceIfPresent(name);
    }

    @Override
    public void loadResourcesFromSelf(String name, Collection<URL> appendTo) {
        try {
            appendTo.addAll(Collections.list(super.findResources(name)));
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Fail to load resources named '%s' from classloader %s", name, this.toString()), e);
        }
    }

    @Override
    public void loadResourcesFromSiblings(String name, Collection<URL> appendTo) {
        for (ClassloaderRef siblingRef : this.siblingRefs) {
            siblingRef.loadResources(name, appendTo);
        }
    }

    @Override
    public void loadResourcesFromParent(String name, Collection<URL> appendTo) {
        this.parentRef.loadResources(name, appendTo);
    }

    public String toString() {
        return String.format("ClassRealm{%s}", this.key);
    }
}

