/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.channel;

import java.io.IOException;
import java.io.Reader;
import java.util.regex.Matcher;
import org.sonar.channel.ChannelException;
import org.sonar.channel.CodeBuffer;
import org.sonar.channel.CodeReaderConfiguration;
import org.sonar.channel.EndMatcher;

public class CodeReader
extends CodeBuffer {
    private CodeBuffer.Cursor previousCursor;

    public CodeReader(Reader code) {
        super(code, new CodeReaderConfiguration());
    }

    public CodeReader(String code) {
        super(code, new CodeReaderConfiguration());
    }

    public CodeReader(Reader code, CodeReaderConfiguration configuration) {
        super(code, configuration);
    }

    public CodeReader(String code, CodeReaderConfiguration configuration) {
        super(code, configuration);
    }

    public final void pop(Appendable appendable) {
        try {
            appendable.append((char)this.pop());
        }
        catch (IOException e) {
            throw new ChannelException(e.getMessage(), e);
        }
    }

    public final char[] peek(int length) {
        char[] result = new char[length];
        int index = 0;
        int nextChar = this.intAt(index);
        while (nextChar != -1 && index < length) {
            result[index] = (char)nextChar;
            nextChar = this.intAt(++index);
        }
        return result;
    }

    public final void peekTo(EndMatcher matcher, Appendable appendable) {
        int index = 0;
        char nextChar = this.charAt(index);
        try {
            while (!matcher.match(nextChar) && nextChar != '\uffffffff') {
                appendable.append(nextChar);
                nextChar = this.charAt(++index);
            }
        }
        catch (IOException e) {
            throw new ChannelException(e.getMessage(), e);
        }
    }

    @Deprecated
    public final String peekTo(EndMatcher matcher) {
        StringBuilder sb = new StringBuilder();
        this.peekTo(matcher, sb);
        return sb.toString();
    }

    @Deprecated
    public final void popTo(EndMatcher matcher, Appendable appendable) {
        this.previousCursor = this.getCursor().clone();
        try {
            do {
                appendable.append((char)this.pop());
            } while (!matcher.match(this.peek()) && this.peek() != -1);
        }
        catch (IOException e) {
            throw new ChannelException(e.getMessage(), e);
        }
    }

    public final int popTo(Matcher matcher, Appendable appendable) {
        return this.popTo(matcher, null, appendable);
    }

    public final int popTo(Matcher matcher, Matcher afterMatcher, Appendable appendable) {
        try {
            matcher.reset(this);
            if (matcher.lookingAt()) {
                if (afterMatcher != null) {
                    afterMatcher.reset(this);
                    afterMatcher.region(matcher.end(), this.length());
                    if (!afterMatcher.lookingAt()) {
                        return -1;
                    }
                }
                this.previousCursor = this.getCursor().clone();
                for (int i2 = 0; i2 < matcher.end(); ++i2) {
                    appendable.append((char)this.pop());
                }
                return matcher.end();
            }
        }
        catch (StackOverflowError e) {
            throw new ChannelException("Unable to apply regular expression '" + matcher.pattern().pattern() + "' at line " + this.getCursor().getLine() + " and column " + this.getCursor().getColumn() + ", because it led to a stack overflow error." + " This error may be due to an inefficient use of alternations - see http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=5050507", e);
        }
        catch (IndexOutOfBoundsException e) {
            return -1;
        }
        catch (IOException e) {
            throw new ChannelException(e.getMessage(), e);
        }
        return -1;
    }

    public final CodeBuffer.Cursor getPreviousCursor() {
        return this.previousCursor;
    }
}

