/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.resources;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.internal.apachecommons.lang3.ArrayUtils;
import org.sonar.api.resources.Language;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

@ScannerSide
@ServerSide
@ComputeEngineSide
public class Languages {
    private static final Logger LOG = Loggers.get(Languages.class);
    private final Map<String, Language> map = new LinkedHashMap<String, Language>();

    public Languages(Language ... languages) {
        LOG.debug("Available languages:");
        for (Language language : languages) {
            this.map.put(language.getKey(), language);
            LOG.debug("  * " + language.getName() + " => \"" + language.getKey() + "\"");
        }
    }

    public Languages() {
        LOG.debug("No language available");
    }

    public String[] getSuffixes(String ... keys2) {
        ArrayList<String> suffixes = new ArrayList<String>();
        for (Map.Entry<String, Language> entry : this.map.entrySet()) {
            if (!ArrayUtils.isEmpty(keys2) && !ArrayUtils.contains(keys2, entry.getKey())) continue;
            suffixes.addAll(Arrays.asList(entry.getValue().getFileSuffixes()));
        }
        return suffixes.toArray(new String[suffixes.size()]);
    }

    public Language get(String key) {
        return this.map.get(key);
    }

    public void add(Language language) {
        this.map.put(language.getKey(), language);
    }

    public Language[] all() {
        Collection<Language> languages = this.map.values();
        return languages.toArray(new Language[languages.size()]);
    }
}

