/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.issue;

import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum IssueStatus {
    OPEN,
    CONFIRMED,
    FALSE_POSITIVE,
    ACCEPTED,
    FIXED,
    IN_SANDBOX;

    private static final Logger LOGGER;

    @CheckForNull
    public static IssueStatus of(@Nullable String status, @Nullable String resolution) {
        if (status == null) {
            LOGGER.warn("Missing status, falling back to {}", (Object)OPEN);
            return OPEN;
        }
        switch (status) {
            case "OPEN": 
            case "REOPENED": {
                return OPEN;
            }
            case "CONFIRMED": {
                return CONFIRMED;
            }
            case "CLOSED": {
                return FIXED;
            }
            case "IN_SANDBOX": {
                return IN_SANDBOX;
            }
            case "REVIEWED": 
            case "TO_REVIEW": {
                return null;
            }
        }
        if ("RESOLVED".equals(status) && resolution != null) {
            switch (resolution) {
                case "FALSE-POSITIVE": {
                    return FALSE_POSITIVE;
                }
                case "WONTFIX": {
                    return ACCEPTED;
                }
                case "FIXED": {
                    return FIXED;
                }
            }
        }
        LOGGER.warn("Can't find mapped issue status for status '{}' and resolution '{}'", (Object)status, (Object)resolution);
        return null;
    }

    static {
        LOGGER = LoggerFactory.getLogger(IssueStatus.class);
    }
}

