/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.internal.apachecommons.validator.routines;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import org.sonar.api.internal.apachecommons.validator.GenericValidator;
import org.sonar.api.internal.apachecommons.validator.routines.AbstractFormatValidator;

public abstract class AbstractCalendarValidator
extends AbstractFormatValidator {
    private static final long serialVersionUID = -1410008585975827379L;
    private final int dateStyle;
    private final int timeStyle;

    public AbstractCalendarValidator(boolean strict, int dateStyle, int timeStyle) {
        super(strict);
        this.dateStyle = dateStyle;
        this.timeStyle = timeStyle;
    }

    private int calculateCompareResult(Calendar value, Calendar compare, int field) {
        return Integer.compare(value.get(field), compare.get(field));
    }

    private int calculateQuarter(Calendar calendar, int monthOfFirstQuarter) {
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int relativeMonth = month >= monthOfFirstQuarter ? month - monthOfFirstQuarter : month + 12 - monthOfFirstQuarter;
        int quarter = relativeMonth / 3 + 1;
        if (month < monthOfFirstQuarter) {
            --year;
        }
        return year * 10 + quarter;
    }

    protected int compare(Calendar value, Calendar compare, int field) {
        int result = this.calculateCompareResult(value, compare, 1);
        if (result != 0 || field == 1) {
            return result;
        }
        if (field == 3) {
            return this.calculateCompareResult(value, compare, 3);
        }
        if (field == 6) {
            return this.calculateCompareResult(value, compare, 6);
        }
        result = this.calculateCompareResult(value, compare, 2);
        if (result != 0 || field == 2) {
            return result;
        }
        if (field == 4) {
            return this.calculateCompareResult(value, compare, 4);
        }
        result = this.calculateCompareResult(value, compare, 5);
        if (result != 0 || field == 5 || field == 7 || field == 8) {
            return result;
        }
        return this.compareTime(value, compare, field);
    }

    protected int compareQuarters(Calendar value, Calendar compare, int monthOfFirstQuarter) {
        int valueQuarter = this.calculateQuarter(value, monthOfFirstQuarter);
        int compareQuarter = this.calculateQuarter(compare, monthOfFirstQuarter);
        return Integer.compare(valueQuarter, compareQuarter);
    }

    protected int compareTime(Calendar value, Calendar compare, int field) {
        int result = this.calculateCompareResult(value, compare, 11);
        if (result != 0 || field == 10 || field == 11) {
            return result;
        }
        result = this.calculateCompareResult(value, compare, 12);
        if (result != 0 || field == 12) {
            return result;
        }
        result = this.calculateCompareResult(value, compare, 13);
        if (result != 0 || field == 13) {
            return result;
        }
        if (field == 14) {
            return this.calculateCompareResult(value, compare, 14);
        }
        throw new IllegalArgumentException("Invalid field: " + field);
    }

    @Override
    protected String format(Object value, Format formatter) {
        if (value == null) {
            return null;
        }
        if (value instanceof Calendar) {
            value = ((Calendar)value).getTime();
        }
        return formatter.format(value);
    }

    public String format(Object value, Locale locale, TimeZone timeZone) {
        return this.format(value, null, locale, timeZone);
    }

    @Override
    public String format(Object value, String pattern, Locale locale) {
        return this.format(value, pattern, locale, null);
    }

    public String format(Object value, String pattern, Locale locale, TimeZone timeZone) {
        DateFormat formatter = (DateFormat)this.getFormat(pattern, locale);
        if (timeZone != null) {
            formatter.setTimeZone(timeZone);
        } else if (value instanceof Calendar) {
            formatter.setTimeZone(((Calendar)value).getTimeZone());
        }
        return this.format(value, formatter);
    }

    public String format(Object value, String pattern, TimeZone timeZone) {
        return this.format(value, pattern, null, timeZone);
    }

    public String format(Object value, TimeZone timeZone) {
        return this.format(value, null, null, timeZone);
    }

    protected Format getFormat(Locale locale) {
        DateFormat formatter;
        if (this.dateStyle >= 0 && this.timeStyle >= 0) {
            formatter = locale == null ? DateFormat.getDateTimeInstance(this.dateStyle, this.timeStyle) : DateFormat.getDateTimeInstance(this.dateStyle, this.timeStyle, locale);
        } else if (this.timeStyle >= 0) {
            formatter = locale == null ? DateFormat.getTimeInstance(this.timeStyle) : DateFormat.getTimeInstance(this.timeStyle, locale);
        } else {
            int useDateStyle = this.dateStyle >= 0 ? this.dateStyle : 3;
            formatter = locale == null ? DateFormat.getDateInstance(useDateStyle) : DateFormat.getDateInstance(useDateStyle, locale);
        }
        formatter.setLenient(false);
        return formatter;
    }

    @Override
    protected Format getFormat(String pattern, Locale locale) {
        DateFormat formatter;
        boolean usePattern;
        boolean bl = usePattern = !GenericValidator.isBlankOrNull(pattern);
        if (!usePattern) {
            formatter = (DateFormat)this.getFormat(locale);
        } else if (locale == null) {
            formatter = new SimpleDateFormat(pattern);
        } else {
            DateFormatSymbols symbols = new DateFormatSymbols(locale);
            formatter = new SimpleDateFormat(pattern, symbols);
        }
        formatter.setLenient(false);
        return formatter;
    }

    @Override
    public boolean isValid(String value, String pattern, Locale locale) {
        return this.parse(value, pattern, locale, null) != null;
    }

    protected Object parse(String value, String pattern, Locale locale, TimeZone timeZone) {
        String value1 = value = value == null ? null : value.trim();
        if (GenericValidator.isBlankOrNull(value1)) {
            return null;
        }
        DateFormat formatter = (DateFormat)this.getFormat(pattern, locale);
        if (timeZone != null) {
            formatter.setTimeZone(timeZone);
        }
        return this.parse(value, formatter);
    }

    @Override
    protected abstract Object processParsedValue(Object var1, Format var2);
}

