/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.impl.ws;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.server.ws.LocalConnector;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.Preconditions;

public abstract class ValidatingRequest
extends Request {
    private static final String COMMA_SPLITTER = ",";
    private WebService.Action action;
    private LocalConnector localConnector;

    public void setAction(WebService.Action action) {
        this.action = action;
    }

    public WebService.Action action() {
        return this.action;
    }

    @Override
    public LocalConnector localConnector() {
        Objects.requireNonNull(this.localConnector, "Local connector has not been set");
        return this.localConnector;
    }

    public void setLocalConnector(LocalConnector lc) {
        this.localConnector = lc;
    }

    @Override
    @CheckForNull
    public String param(String key) {
        WebService.Param definition = this.action.param(key);
        String rawValue = this.readParam(key, definition);
        String rawValueOrDefault = Objects.toString(rawValue, definition.defaultValue());
        String value = rawValueOrDefault == null ? null : ValidatingRequest.trim(rawValueOrDefault);
        ValidatingRequest.validateRequiredValue(key, definition, rawValue);
        if (value == null) {
            return null;
        }
        ValidatingRequest.validatePossibleValues(key, value, definition);
        ValidatingRequest.validateMaximumLength(key, definition, rawValueOrDefault);
        ValidatingRequest.validateMinimumLength(key, definition, rawValueOrDefault);
        ValidatingRequest.validateMaximumValue(key, definition, value);
        return value;
    }

    @Override
    public List<String> multiParam(String key) {
        WebService.Param definition = this.action.param(key);
        if (definition == null) {
            throw new IllegalArgumentException("Parameter '" + key + "' not found for action '" + this.action.key() + "'");
        }
        List<String> values2 = this.readMultiParamOrDefaultValue(key, definition);
        return ValidatingRequest.validateValues(values2, definition);
    }

    private static String trim(String s) {
        int end;
        int begin;
        for (begin = 0; begin < s.length() && Character.isWhitespace(s.charAt(begin)); ++begin) {
        }
        for (end = s.length(); end > begin && Character.isWhitespace(s.charAt(end - 1)); --end) {
        }
        return s.substring(begin, end);
    }

    @Override
    @CheckForNull
    public InputStream paramAsInputStream(String key) {
        return this.readInputStreamParam(key);
    }

    @Override
    @CheckForNull
    public Request.Part paramAsPart(String key) {
        return this.readPart(key);
    }

    @Override
    @CheckForNull
    public List<String> paramAsStrings(String key) {
        WebService.Param definition = this.action.param(key);
        String value = Objects.toString(this.readParam(key, definition), definition.defaultValue());
        if (value == null) {
            return null;
        }
        List<String> values2 = Arrays.stream(value.split(COMMA_SPLITTER)).map(String::trim).filter(s -> !s.isEmpty()).toList();
        return ValidatingRequest.validateValues(values2, definition);
    }

    @Override
    @CheckForNull
    public <E extends Enum<E>> List<E> paramAsEnums(String key, Class<E> enumClass) {
        List<String> values2 = this.paramAsStrings(key);
        if (values2 == null) {
            return null;
        }
        return values2.stream().filter(s -> !s.isEmpty()).map(value -> Enum.valueOf(enumClass, value)).toList();
    }

    @CheckForNull
    private String readParam(String key, @Nullable WebService.Param definition) {
        String param;
        Preconditions.checkArgument(definition != null, "BUG - parameter '%s' is undefined for action '%s'", key, this.action.key());
        String deprecatedKey = definition.deprecatedKey();
        String string = param = deprecatedKey != null ? Objects.toString(this.readParam(deprecatedKey), this.readParam(key)) : this.readParam(key);
        if (param != null && param.contains("\u0000")) {
            throw new IllegalArgumentException("Request parameters are not allowed to contain NUL character");
        }
        return param;
    }

    private List<String> readMultiParamOrDefaultValue(String key, @Nullable WebService.Param definition) {
        List<String> deprecatedKeyValues;
        Preconditions.checkArgument(definition != null, "BUG - parameter '%s' is undefined for action '%s'", key, this.action.key());
        List<String> keyValues = this.readMultiParam(key);
        if (!keyValues.isEmpty()) {
            return keyValues;
        }
        String deprecatedKey = definition.deprecatedKey();
        List<String> list = deprecatedKeyValues = deprecatedKey == null ? Collections.emptyList() : this.readMultiParam(deprecatedKey);
        if (!deprecatedKeyValues.isEmpty()) {
            return deprecatedKeyValues;
        }
        String defaultValue = definition.defaultValue();
        return defaultValue == null ? Collections.emptyList() : Collections.singletonList(defaultValue);
    }

    @CheckForNull
    protected abstract String readParam(String var1);

    protected abstract List<String> readMultiParam(String var1);

    @CheckForNull
    protected abstract InputStream readInputStreamParam(String var1);

    @CheckForNull
    protected abstract Request.Part readPart(String var1);

    private static List<String> validateValues(List<String> values2, WebService.Param definition) {
        Integer maximumValues = definition.maxValuesAllowed();
        Preconditions.checkArgument(maximumValues == null || values2.size() <= maximumValues, "'%s' can contain only %s values, got %s", definition.key(), maximumValues, values2.size());
        values2.forEach(value -> ValidatingRequest.validatePossibleValues(definition.key(), value, definition));
        return values2;
    }

    private static void validatePossibleValues(String key, String value, WebService.Param definition) {
        Set<String> possibleValues = definition.possibleValues();
        if (possibleValues == null) {
            return;
        }
        Preconditions.checkArgument(possibleValues.contains(value), "Value of parameter '%s' (%s) must be one of: %s", key, value, possibleValues);
    }

    private static void validateMaximumLength(String key, WebService.Param definition, String valueOrDefault) {
        Integer maximumLength = definition.maximumLength();
        if (maximumLength == null) {
            return;
        }
        int valueLength = valueOrDefault.length();
        Preconditions.checkArgument(valueLength <= maximumLength, "'%s' length (%s) is longer than the maximum authorized (%s)", key, valueLength, maximumLength);
    }

    private static void validateMinimumLength(String key, WebService.Param definition, String valueOrDefault) {
        Integer minimumLength = definition.minimumLength();
        if (minimumLength == null) {
            return;
        }
        int valueLength = valueOrDefault.length();
        Preconditions.checkArgument(valueLength >= minimumLength, "'%s' length (%s) is shorter than the minimum authorized (%s)", key, valueLength, minimumLength);
    }

    private static void validateMaximumValue(String key, WebService.Param definition, String value) {
        Integer maximumValue = definition.maximumValue();
        if (maximumValue == null) {
            return;
        }
        int valueAsInt = ValidatingRequest.validateAsNumeric(key, value);
        Preconditions.checkArgument(valueAsInt <= maximumValue, "'%s' value (%s) must be less than %s", key, valueAsInt, maximumValue);
    }

    private static void validateRequiredValue(String key, WebService.Param definition, @Nullable String value) {
        boolean required = definition.isRequired();
        if (required) {
            Preconditions.checkArgument(value != null, String.format("The '%s' parameter is missing", key));
        }
    }

    private static int validateAsNumeric(String key, String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException exception) {
            throw new IllegalArgumentException(String.format("'%s' value '%s' cannot be parsed as an integer", key, value), exception);
        }
    }
}

