/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.impl.utils;

import java.io.File;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.junit.rules.ExternalResource;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.sonar.api.utils.TempFolder;

public class JUnitTempFolder
extends ExternalResource
implements TempFolder {
    private final TemporaryFolder junit = new TemporaryFolder();

    public Statement apply(Statement base, Description description) {
        return this.junit.apply(base, description);
    }

    protected void before() throws Throwable {
        this.junit.create();
    }

    protected void after() {
        this.junit.delete();
    }

    @Override
    public File newDir() {
        try {
            return this.junit.newFolder();
        }
        catch (IOException e) {
            throw new IllegalStateException("Fail to create temp dir", e);
        }
    }

    @Override
    public File newDir(String name) {
        try {
            return this.junit.newFolder(name);
        }
        catch (IOException e) {
            throw new IllegalStateException("Fail to create temp dir", e);
        }
    }

    @Override
    public File newFile() {
        try {
            return this.junit.newFile();
        }
        catch (IOException e) {
            throw new IllegalStateException("Fail to create temp file", e);
        }
    }

    @Override
    public File newFile(@Nullable String prefix, @Nullable String suffix) {
        try {
            return this.junit.newFile(StringUtils.defaultString(prefix) + "-" + StringUtils.defaultString(suffix));
        }
        catch (IOException e) {
            throw new IllegalStateException("Fail to create temp file", e);
        }
    }

    public File getRoot() {
        return this.junit.getRoot();
    }
}

