/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.config.internal;

import java.io.IOException;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.ArrayUtils;

public class MultivalueProperty {
    private MultivalueProperty() {
    }

    public static String[] parseAsCsv(String key, String value) {
        return MultivalueProperty.parseAsCsv(key, value, UnaryOperator.identity());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] parseAsCsv(String key, String value, UnaryOperator<String> valueProcessor) {
        String cleanValue = MultivalueProperty.trimFieldsAndRemoveEmptyFields(value);
        ArrayList<String> result = new ArrayList<String>();
        try (CSVParser csvParser = CSVFormat.RFC4180.builder().setSkipHeaderRecord(true).setIgnoreEmptyLines(true).setIgnoreSurroundingSpaces(true).build().parse(new StringReader(cleanValue));){
            List<CSVRecord> records = csvParser.getRecords();
            if (records.isEmpty()) {
                String[] stringArray2 = ArrayUtils.EMPTY_STRING_ARRAY;
                return stringArray2;
            }
            MultivalueProperty.processRecords(result, records, valueProcessor);
            String[] stringArray = result.toArray(new String[result.size()]);
            return stringArray;
        }
        catch (IOException | UncheckedIOException e) {
            throw new IllegalStateException("Property: '" + key + "' doesn't contain a valid CSV value: '" + value + "'", e);
        }
    }

    private static void processRecords(List<String> result, List<CSVRecord> records, Function<String, String> valueProcessor) {
        for (CSVRecord csvRecord : records) {
            String next;
            Iterator<String> it = csvRecord.iterator();
            if (!result.isEmpty() && !(next = it.next()).isEmpty()) {
                int lastItemIdx = result.size() - 1;
                String previous = result.get(lastItemIdx);
                if (previous.isEmpty()) {
                    result.set(lastItemIdx, valueProcessor.apply(next));
                } else {
                    result.set(lastItemIdx, valueProcessor.apply(previous + "\n" + next));
                }
            }
            it.forEachRemaining(s -> {
                String apply = (String)valueProcessor.apply((String)s);
                result.add(apply);
            });
        }
    }

    static String trimFieldsAndRemoveEmptyFields(String str) {
        char[] chars = str.toCharArray();
        char[] res = new char[chars.length];
        boolean inField = false;
        boolean inQuotes = false;
        int resI = 0;
        for (int i2 = 0; i2 < chars.length; ++i2) {
            boolean isTrimmed;
            boolean isSeparator;
            boolean bl = isSeparator = chars[i2] == ',';
            if (!inQuotes && isSeparator) {
                inField = false;
                if (resI <= 0) continue;
                resI = MultivalueProperty.retroTrim(res, resI);
                continue;
            }
            boolean bl2 = isTrimmed = !inQuotes && MultivalueProperty.istrimmable(chars[i2]);
            if (isTrimmed && !inField) continue;
            boolean isEscape = MultivalueProperty.isEscapeChar(chars[i2]);
            if (isEscape) {
                boolean bl3 = inQuotes = !inQuotes;
            }
            if (!inField && resI > 0) {
                res[resI] = 44;
                ++resI;
            }
            inField = true;
            res[resI] = chars[i2];
            ++resI;
        }
        if (!inQuotes) {
            resI = MultivalueProperty.retroTrim(res, resI);
        }
        return new String(res, 0, resI);
    }

    private static boolean isEscapeChar(char aChar) {
        return aChar == '\"';
    }

    private static boolean istrimmable(char aChar) {
        return aChar <= ' ';
    }

    private static int retroTrim(char[] res, int resI) {
        int i2;
        for (i2 = resI; i2 >= 1; --i2) {
            if (MultivalueProperty.istrimmable(res[i2 - 1])) continue;
            return i2;
        }
        return i2;
    }
}

