/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.config.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.sonar.api.config.Configuration;
import org.sonar.api.config.PropertyDefinitions;
import org.sonar.api.config.internal.ConfigurationBridge;
import org.sonar.api.config.internal.Encryption;
import org.sonar.api.config.internal.Settings;
import org.sonar.api.utils.System2;

public class MapSettings
extends Settings {
    private final Map<String, String> props = new HashMap<String, String>();
    private final ConfigurationBridge configurationBridge = new ConfigurationBridge(this);

    public MapSettings() {
        this(new PropertyDefinitions(System2.INSTANCE, new Object[0]));
    }

    public MapSettings(PropertyDefinitions definitions) {
        super(definitions, new Encryption(null));
    }

    @Override
    protected Optional<String> get(String key) {
        return Optional.ofNullable(this.props.get(key));
    }

    @Override
    protected void set(String key, String value) {
        this.props.put(Objects.requireNonNull(key, "key can't be null"), Objects.requireNonNull(value, "value can't be null").trim());
    }

    @Override
    protected void remove(String key) {
        this.props.remove(key);
    }

    @Override
    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.props);
    }

    public MapSettings clear() {
        this.props.clear();
        return this;
    }

    @Override
    public MapSettings setProperty(String key, String value) {
        return (MapSettings)super.setProperty(key, value);
    }

    @Override
    public MapSettings setProperty(String key, Integer value) {
        return (MapSettings)super.setProperty(key, value);
    }

    @Override
    public MapSettings setProperty(String key, Boolean value) {
        return (MapSettings)super.setProperty(key, value);
    }

    @Override
    public MapSettings setProperty(String key, Long value) {
        return (MapSettings)super.setProperty(key, value);
    }

    public Configuration asConfig() {
        return this.configurationBridge;
    }
}

