/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.ExtensionPoint;
import org.sonar.api.Property;
import org.sonar.api.PropertyType;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.config.PropertyFieldDefinition;
import org.sonar.api.internal.apachecommons.lang3.StringUtils;
import org.sonar.api.internal.apachecommons.lang3.Strings;
import org.sonar.api.internal.apachecommons.lang3.math.NumberUtils;
import org.sonar.api.internal.apachecommons.validator.routines.EmailValidator;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.Preconditions;
import org.sonarsource.api.sonarlint.SonarLintSide;

@ScannerSide
@ServerSide
@ComputeEngineSide
@SonarLintSide
@ExtensionPoint
public final class PropertyDefinition {
    private final String key;
    private final String defaultValue;
    private final String name;
    private final PropertyType type;
    private final List<String> options;
    private final String description;
    private final String category;
    private final List<ConfigScope> configScopes;
    private final boolean global;
    private final boolean multiValues;
    private final String deprecatedKey;
    private final List<PropertyFieldDefinition> fields;
    private final String subCategory;
    private final int index;

    private PropertyDefinition(Builder builder) {
        this.key = builder.key;
        this.name = builder.name;
        this.description = builder.description;
        this.defaultValue = builder.defaultValue;
        this.category = builder.category;
        this.subCategory = builder.subCategory;
        this.global = builder.global;
        this.type = builder.type;
        this.options = builder.options;
        this.multiValues = builder.multiValues;
        this.fields = builder.fields;
        this.deprecatedKey = builder.deprecatedKey;
        this.configScopes = new ArrayList<ConfigScope>(builder.onConfigScopes);
        this.configScopes.addAll(builder.onlyOnConfigScopes);
        this.index = builder.index;
    }

    public static Builder builder(String key) {
        return new Builder(key);
    }

    static PropertyDefinition create(Property annotation) {
        Builder builder = PropertyDefinition.builder(annotation.key()).name(annotation.name()).defaultValue(annotation.defaultValue()).description(annotation.description()).category(annotation.category()).type(annotation.type()).options(Arrays.asList(annotation.options())).multiValues(annotation.multiValues()).fields(PropertyFieldDefinition.create(annotation.fields())).deprecatedKey(annotation.deprecatedKey());
        ArrayList<ConfigScope> configScopes = new ArrayList<ConfigScope>();
        if (annotation.project()) {
            configScopes.add(ConfigScope.PROJECT);
        }
        if (annotation.module()) {
            configScopes.add(ConfigScope.MODULE);
        }
        if (annotation.global()) {
            builder.onConfigScopes(configScopes);
        } else {
            builder.onlyOnConfigScopes(configScopes);
        }
        return builder.build();
    }

    public static Result validate(PropertyType type, @Nullable String value, List<String> options) {
        if (StringUtils.isBlank(value)) {
            return Result.SUCCESS;
        }
        EnumMap<PropertyType, Function<String, Result>> validations = PropertyDefinition.createValidations(options);
        return validations.getOrDefault((Object)type, aValue -> Result.SUCCESS).apply(value);
    }

    private static EnumMap<PropertyType, Function<String, Result>> createValidations(List<String> options) {
        EnumMap<PropertyType, Function<String, Result>> map = new EnumMap<PropertyType, Function<String, Result>>(PropertyType.class);
        map.put(PropertyType.BOOLEAN, PropertyDefinition.validateBoolean());
        map.put(PropertyType.INTEGER, PropertyDefinition.validateInteger());
        map.put(PropertyType.FLOAT, PropertyDefinition.validateFloat());
        map.put(PropertyType.REGULAR_EXPRESSION, PropertyDefinition.validateRegexp());
        map.put(PropertyType.EMAIL, PropertyDefinition.validateEmail());
        map.put(PropertyType.SINGLE_SELECT_LIST, aValue -> options.contains(aValue) ? Result.SUCCESS : Result.newError("notInOptions"));
        return map;
    }

    private static Function<String, Result> validateBoolean() {
        return value -> {
            if (!Strings.CI.equals((String)value, "true") && !Strings.CI.equals((String)value, "false")) {
                return Result.newError("notBoolean");
            }
            return Result.SUCCESS;
        };
    }

    private static Function<String, Result> validateInteger() {
        return value -> {
            if (!NumberUtils.isDigits(value)) {
                return Result.newError("notInteger");
            }
            return Result.SUCCESS;
        };
    }

    private static Function<String, Result> validateFloat() {
        return value -> {
            try {
                Double.parseDouble(value);
                return Result.SUCCESS;
            }
            catch (NumberFormatException e) {
                return Result.newError("notFloat");
            }
        };
    }

    private static Function<String, Result> validateRegexp() {
        return value -> {
            try {
                Pattern.compile(value);
                return Result.SUCCESS;
            }
            catch (PatternSyntaxException e) {
                return Result.newError("notRegexp");
            }
        };
    }

    private static Function<String, Result> validateEmail() {
        return value -> {
            if (!EmailValidator.getInstance(true, true).isValid((String)value)) {
                return Result.newError("notEmail");
            }
            return Result.SUCCESS;
        };
    }

    public Result validate(@Nullable String value) {
        return PropertyDefinition.validate(this.type, value, this.options);
    }

    public String key() {
        return this.key;
    }

    public String defaultValue() {
        return this.defaultValue;
    }

    public String name() {
        return this.name;
    }

    public PropertyType type() {
        return this.type;
    }

    public List<String> options() {
        return this.options;
    }

    public String description() {
        return this.description;
    }

    public String category() {
        return this.category;
    }

    public String subCategory() {
        return this.subCategory;
    }

    @Deprecated(since="10.13", forRemoval=true)
    public List<String> qualifiers() {
        return this.configScopes.stream().map(rec$ -> ((ConfigScope)((Object)((Object)rec$))).getKey()).collect(Collectors.toList());
    }

    public List<ConfigScope> configScopes() {
        return this.configScopes;
    }

    public boolean global() {
        return this.global;
    }

    public boolean multiValues() {
        return this.multiValues;
    }

    public List<PropertyFieldDefinition> fields() {
        return this.fields;
    }

    public String deprecatedKey() {
        return this.deprecatedKey;
    }

    public int index() {
        return this.index;
    }

    public String toString() {
        return this.key;
    }

    public static class Builder {
        private final String key;
        private String name = "";
        private String description = "";
        private String defaultValue = "";
        private String category = "";
        private String subCategory = "";
        private final List<ConfigScope> onConfigScopes = new ArrayList<ConfigScope>();
        private final List<ConfigScope> onlyOnConfigScopes = new ArrayList<ConfigScope>();
        private boolean global = true;
        private PropertyType type = PropertyType.STRING;
        private final List<String> options = new ArrayList<String>();
        private boolean multiValues = false;
        private final List<PropertyFieldDefinition> fields = new ArrayList<PropertyFieldDefinition>();
        private String deprecatedKey = "";
        private boolean hidden = false;
        private int index = 999;

        private Builder(String key) {
            this.key = key;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder category(String category) {
            this.category = category;
            return this;
        }

        public Builder subCategory(String subCategory) {
            this.subCategory = subCategory;
            return this;
        }

        public Builder onConfigScopes(ConfigScope first, ConfigScope ... rest) {
            Builder.addQualifiers(this.onConfigScopes, first, rest);
            this.global = true;
            return this;
        }

        @Deprecated(since="10.13", forRemoval=true)
        public Builder onQualifiers(String first, String ... rest) {
            Builder.addQualifiers(this.onConfigScopes, first, rest);
            this.global = true;
            return this;
        }

        public Builder onConfigScopes(Collection<ConfigScope> configScopes) {
            Builder.addQualifiers(this.onConfigScopes, configScopes);
            this.global = true;
            return this;
        }

        @Deprecated(since="10.13", forRemoval=true)
        public Builder onQualifiers(List<String> qualifiers) {
            Builder.addQualifiers(this.onConfigScopes, qualifiers);
            this.global = true;
            return this;
        }

        public Builder onlyOnConfigScopes(ConfigScope first, ConfigScope ... rest) {
            Builder.addQualifiers(this.onlyOnConfigScopes, first, rest);
            this.global = false;
            return this;
        }

        @Deprecated(since="10.13", forRemoval=true)
        public Builder onlyOnQualifiers(String first, String ... rest) {
            Builder.addQualifiers(this.onlyOnConfigScopes, first, rest);
            this.global = false;
            return this;
        }

        public Builder onlyOnConfigScopes(Collection<ConfigScope> configScopes) {
            Builder.addQualifiers(this.onlyOnConfigScopes, configScopes);
            this.global = false;
            return this;
        }

        @Deprecated(since="10.13", forRemoval=true)
        public Builder onlyOnQualifiers(List<String> qualifiers) {
            Builder.addQualifiers(this.onlyOnConfigScopes, qualifiers);
            this.global = false;
            return this;
        }

        private static void addQualifiers(List<ConfigScope> target, ConfigScope first, ConfigScope ... rest) {
            ArrayList<ConfigScope> configScopes = new ArrayList<ConfigScope>();
            configScopes.add(first);
            configScopes.addAll(Arrays.asList(rest));
            Builder.addQualifiers(target, configScopes);
        }

        private static void addQualifiers(List<ConfigScope> target, String first, String ... rest) {
            ArrayList<ConfigScope> configScopes = new ArrayList<ConfigScope>();
            configScopes.add(Builder.validateQualifier(first));
            for (String qualifier : rest) {
                configScopes.add(Builder.validateQualifier(qualifier));
            }
            Builder.addQualifiers(target, configScopes);
        }

        private static void addQualifiers(List<ConfigScope> target, List<String> qualifiers) {
            for (String qualifier : qualifiers) {
                target.add(Builder.validateQualifier(qualifier));
            }
        }

        private static void addQualifiers(List<ConfigScope> target, Collection<ConfigScope> configScopes) {
            target.addAll(configScopes);
        }

        private static ConfigScope validateQualifier(@Nullable String qualifierStr) {
            Objects.requireNonNull(qualifierStr, "Qualifier cannot be null");
            ConfigScope qualifier = ConfigScope.fromKey(qualifierStr);
            Preconditions.checkArgument(qualifier != null, "Qualifier must be one of %s", Arrays.stream(ConfigScope.values()).map(rec$ -> ((ConfigScope)((Object)((Object)rec$))).getKey()).collect(Collectors.toList()));
            return qualifier;
        }

        public Builder type(PropertyType type) {
            this.type = type;
            return this;
        }

        public Builder options(String first, String ... rest) {
            this.options.add(first);
            this.options.addAll(Arrays.asList(rest));
            return this;
        }

        public Builder options(List<String> options) {
            this.options.addAll(options);
            return this;
        }

        public Builder multiValues(boolean multiValues) {
            this.multiValues = multiValues;
            return this;
        }

        public Builder fields(PropertyFieldDefinition first, PropertyFieldDefinition ... rest) {
            this.fields.add(first);
            this.fields.addAll(Arrays.asList(rest));
            return this;
        }

        public Builder fields(List<PropertyFieldDefinition> fields) {
            this.fields.addAll(fields);
            return this;
        }

        public Builder deprecatedKey(String deprecatedKey) {
            this.deprecatedKey = deprecatedKey;
            return this;
        }

        public Builder hidden() {
            this.hidden = true;
            return this;
        }

        public Builder index(int index) {
            this.index = index;
            return this;
        }

        public PropertyDefinition build() {
            Preconditions.checkArgument(!StringUtils.isEmpty(this.key), "Key must be set");
            this.fixType(this.key, this.type);
            Preconditions.checkArgument(this.onConfigScopes.isEmpty() || this.onlyOnConfigScopes.isEmpty(), "Cannot use both forQualifiers and onlyForQualifiers");
            Preconditions.checkArgument(!this.hidden || this.onConfigScopes.isEmpty() && this.onlyOnConfigScopes.isEmpty(), "Cannot be hidden and defining qualifiers on which to display");
            Preconditions.checkArgument(!PropertyType.JSON.equals((Object)this.type) || !this.multiValues, "Multivalues are not allowed to be defined for JSON-type property.");
            if (this.hidden) {
                this.global = false;
            }
            if (!this.fields.isEmpty()) {
                this.type = PropertyType.PROPERTY_SET;
            }
            return new PropertyDefinition(this);
        }

        private void fixType(String key, PropertyType type) {
            if (type == PropertyType.STRING && Strings.CS.endsWith(key, ".password.secured")) {
                this.type = PropertyType.PASSWORD;
            }
        }
    }

    public static final class Result {
        private static final Result SUCCESS = new Result(null);
        private final String errorKey;

        private Result(@Nullable String errorKey) {
            this.errorKey = errorKey;
        }

        private static Result newError(String key) {
            return new Result(key);
        }

        public boolean isValid() {
            return StringUtils.isBlank(this.errorKey);
        }

        @Nullable
        public String getErrorKey() {
            return this.errorKey;
        }
    }

    public static enum ConfigScope {
        PROJECT("TRK"),
        VIEW("VW"),
        MODULE("BRC"),
        SUB_VIEW("SVW"),
        APP("APP");

        private final String key;

        private ConfigScope(String key) {
            this.key = key;
        }

        @CheckForNull
        private static ConfigScope fromKey(String key) {
            return Arrays.stream(ConfigScope.values()).filter(configScope -> configScope.key.equals(key)).findAny().orElse(null);
        }

        private String getKey() {
            return this.key;
        }
    }
}

