/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.sonar.api.batch.sensor.code.NewSignificantCode;
import org.sonar.api.batch.sensor.code.internal.DefaultSignificantCode;
import org.sonar.api.batch.sensor.coverage.NewCoverage;
import org.sonar.api.batch.sensor.coverage.internal.DefaultCoverage;
import org.sonar.api.batch.sensor.cpd.NewCpdTokens;
import org.sonar.api.batch.sensor.cpd.internal.DefaultCpdTokens;
import org.sonar.api.batch.sensor.error.AnalysisError;
import org.sonar.api.batch.sensor.highlighting.NewHighlighting;
import org.sonar.api.batch.sensor.highlighting.internal.DefaultHighlighting;
import org.sonar.api.batch.sensor.internal.SensorStorage;
import org.sonar.api.batch.sensor.issue.ExternalIssue;
import org.sonar.api.batch.sensor.issue.Issue;
import org.sonar.api.batch.sensor.measure.Measure;
import org.sonar.api.batch.sensor.rule.AdHocRule;
import org.sonar.api.batch.sensor.symbol.NewSymbolTable;
import org.sonar.api.batch.sensor.symbol.internal.DefaultSymbolTable;
import org.sonar.api.utils.Preconditions;

class InMemorySensorStorage
implements SensorStorage {
    Map<String, Map<String, Measure>> measuresByComponentAndMetric = new HashMap<String, Map<String, Measure>>();
    Collection<Issue> allIssues = new ArrayList<Issue>();
    Collection<ExternalIssue> allExternalIssues = new ArrayList<ExternalIssue>();
    Collection<AdHocRule> allAdHocRules = new ArrayList<AdHocRule>();
    Collection<AnalysisError> allAnalysisErrors = new ArrayList<AnalysisError>();
    Map<String, NewHighlighting> highlightingByComponent = new HashMap<String, NewHighlighting>();
    Map<String, DefaultCpdTokens> cpdTokensByComponent = new HashMap<String, DefaultCpdTokens>();
    Map<String, List<DefaultCoverage>> coverageByComponent = new HashMap<String, List<DefaultCoverage>>();
    Map<String, DefaultSymbolTable> symbolsPerComponent = new HashMap<String, DefaultSymbolTable>();
    Map<String, String> contextProperties = new HashMap<String, String>();
    Map<String, String> telemetryEntries = new HashMap<String, String>();
    Map<String, AnalysisData> analysisDataEntries = new HashMap<String, AnalysisData>();
    Map<String, DefaultSignificantCode> significantCodePerComponent = new HashMap<String, DefaultSignificantCode>();

    InMemorySensorStorage() {
    }

    @Override
    public void store(Measure measure) {
        String componentKey = measure.inputComponent().key();
        String metricKey = measure.metric().key();
        if (this.measuresByComponentAndMetric.getOrDefault(componentKey, Collections.emptyMap()).containsKey(metricKey)) {
            throw new IllegalStateException("Can not add the same measure twice");
        }
        this.measuresByComponentAndMetric.computeIfAbsent(componentKey, x -> new HashMap()).put(metricKey, measure);
    }

    @Override
    public void store(Issue issue) {
        this.allIssues.add(issue);
    }

    @Override
    public void store(AdHocRule adHocRule) {
        this.allAdHocRules.add(adHocRule);
    }

    @Override
    public void store(NewHighlighting newHighlighting) {
        DefaultHighlighting highlighting = (DefaultHighlighting)newHighlighting;
        String fileKey = highlighting.inputFile().key();
        if (this.highlightingByComponent.containsKey(fileKey)) {
            throw new UnsupportedOperationException("Trying to save highlighting twice for the same file is not supported: " + String.valueOf(highlighting.inputFile()));
        }
        this.highlightingByComponent.put(fileKey, highlighting);
    }

    @Override
    public void store(NewCoverage coverage) {
        DefaultCoverage defaultCoverage = (DefaultCoverage)coverage;
        String fileKey = defaultCoverage.inputFile().key();
        this.coverageByComponent.computeIfAbsent(fileKey, x -> new ArrayList()).add(defaultCoverage);
    }

    @Override
    public void store(NewCpdTokens cpdTokens) {
        DefaultCpdTokens defaultCpdTokens = (DefaultCpdTokens)cpdTokens;
        String fileKey = defaultCpdTokens.inputFile().key();
        if (this.cpdTokensByComponent.containsKey(fileKey)) {
            throw new UnsupportedOperationException("Trying to save CPD tokens twice for the same file is not supported: " + String.valueOf(defaultCpdTokens.inputFile()));
        }
        this.cpdTokensByComponent.put(fileKey, defaultCpdTokens);
    }

    @Override
    public void store(NewSymbolTable newSymbolTable) {
        DefaultSymbolTable symbolTable = (DefaultSymbolTable)newSymbolTable;
        String fileKey = symbolTable.inputFile().key();
        if (this.symbolsPerComponent.containsKey(fileKey)) {
            throw new UnsupportedOperationException("Trying to save symbol table twice for the same file is not supported: " + String.valueOf(symbolTable.inputFile()));
        }
        this.symbolsPerComponent.put(fileKey, symbolTable);
    }

    @Override
    public void store(AnalysisError analysisError) {
        this.allAnalysisErrors.add(analysisError);
    }

    @Override
    public void storeProperty(String key, String value) {
        Preconditions.checkArgument(key != null, "Key of context property must not be null");
        Preconditions.checkArgument(value != null, "Value of context property must not be null");
        this.contextProperties.put(key, value);
    }

    public void storeTelemetry(String key, String value) {
        Preconditions.checkArgument(key != null, "Key of context property must not be null");
        Preconditions.checkArgument(value != null, "Value of context property must not be null");
        if (this.telemetryEntries.size() < 1000 || this.telemetryEntries.containsKey(key)) {
            this.telemetryEntries.put(key, value);
        }
    }

    @Override
    public void store(ExternalIssue issue) {
        this.allExternalIssues.add(issue);
    }

    @Override
    public void store(NewSignificantCode newSignificantCode) {
        DefaultSignificantCode significantCode = (DefaultSignificantCode)newSignificantCode;
        String fileKey = significantCode.inputFile().key();
        if (this.significantCodePerComponent.containsKey(fileKey)) {
            throw new UnsupportedOperationException("Trying to save significant code information twice for the same file is not supported: " + String.valueOf(significantCode.inputFile()));
        }
        this.significantCodePerComponent.put(fileKey, significantCode);
    }

    public void storeAnalysisData(String key, String mimeType, InputStream data) {
        Preconditions.checkArgument(!StringUtils.isBlank(key), "Key must not be null");
        Preconditions.checkArgument(!StringUtils.isBlank(mimeType), "MimeType must not be null");
        Preconditions.checkArgument(data != null, "Data must not be null");
        if (this.analysisDataEntries.containsKey(key)) {
            throw new UnsupportedOperationException("Trying to save analysis data twice for the same key is not supported: " + key);
        }
        try (InputStream inputStream2 = data;){
            byte[] bytes = data.readAllBytes();
            this.analysisDataEntries.put(key, new AnalysisData(key, mimeType, bytes));
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read data from InputStream", e);
        }
    }

    record AnalysisData(String key, String mimeType, byte[] data) {
    }
}

