/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.fs.internal.predicates;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.predicates.AbstractFilePredicate;
import org.sonar.api.batch.fs.internal.predicates.FalsePredicate;
import org.sonar.api.batch.fs.internal.predicates.OperatorPredicate;
import org.sonar.api.batch.fs.internal.predicates.TruePredicate;

class OrPredicate
extends AbstractFilePredicate
implements OperatorPredicate {
    private final List<FilePredicate> predicates = new ArrayList<FilePredicate>();

    private OrPredicate() {
    }

    public static FilePredicate create(Collection<FilePredicate> predicates) {
        if (predicates.isEmpty()) {
            return TruePredicate.TRUE;
        }
        OrPredicate result = new OrPredicate();
        for (FilePredicate filePredicate : predicates) {
            if (filePredicate == TruePredicate.TRUE) {
                return TruePredicate.TRUE;
            }
            if (filePredicate == FalsePredicate.FALSE) continue;
            if (filePredicate instanceof OrPredicate) {
                OrPredicate orPredicate = (OrPredicate)filePredicate;
                result.predicates.addAll(orPredicate.predicates);
                continue;
            }
            result.predicates.add(filePredicate);
        }
        return result;
    }

    @Override
    public boolean apply(InputFile f) {
        for (FilePredicate predicate : this.predicates) {
            if (!predicate.apply(f)) continue;
            return true;
        }
        return false;
    }

    Collection<FilePredicate> predicates() {
        return this.predicates;
    }

    @Override
    public List<FilePredicate> operands() {
        return this.predicates;
    }
}

