/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.fs.internal.predicates;

import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.predicates.AbstractFilePredicate;
import org.sonar.api.scan.filesystem.PathResolver;
import org.sonar.api.utils.PathUtils;

class AbsolutePathPredicate
extends AbstractFilePredicate {
    private static final Logger LOG = LoggerFactory.getLogger(AbsolutePathPredicate.class);
    private final String path;
    private final Path baseDir;
    private final String sanitizedPath;

    AbsolutePathPredicate(String path, Path baseDir) {
        this.baseDir = baseDir;
        this.path = path;
        this.sanitizedPath = PathUtils.sanitize(path);
    }

    @Override
    public boolean apply(InputFile f) {
        return this.sanitizedPath.equals(f.absolutePath());
    }

    @Override
    public Iterable<InputFile> get(FileSystem.Index index) {
        if (this.sanitizedPath == null) {
            LOG.debug("Cannot resolve absolute path '{}' as it is not a valid path", (Object)this.path);
            return Collections.emptyList();
        }
        String relative = PathUtils.sanitize(new PathResolver().relativePath(this.baseDir.toFile(), new File(this.sanitizedPath)));
        if (relative == null) {
            return Collections.emptyList();
        }
        InputFile f = index.inputFile(relative);
        return f != null ? List.of(f) : Collections.emptyList();
    }

    @Override
    public int priority() {
        return 20;
    }
}

