/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.fs.internal.charhandler;

import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.internal.charhandler.CharHandler;
import org.sonar.api.notifications.AnalysisWarnings;

public class LineCounter
extends CharHandler {
    private static final Logger LOG = LoggerFactory.getLogger(LineCounter.class);
    private final AnalysisWarnings analysisWarnings;
    private final String filePath;
    private final Charset encoding;
    private int lines = 1;
    private int nonBlankLines = 0;
    private boolean blankLine = true;
    boolean alreadyLoggedInvalidCharacter = false;

    public LineCounter(AnalysisWarnings analysisWarnings, String filePath, Charset encoding) {
        this.analysisWarnings = analysisWarnings;
        this.filePath = filePath;
        this.encoding = encoding;
    }

    @Override
    public void handleAll(char c) {
        if (!this.alreadyLoggedInvalidCharacter && c == '\ufffd') {
            this.analysisWarnings.addUnique("There are problems with file encoding in the source code. Please check the scanner logs for more details.");
            LOG.warn("Invalid character encountered in file {} at line {} for encoding {}. Please fix file content or configure the encoding to be used using property '{}'.", this.filePath, this.lines, this.encoding, "sonar.sourceEncoding");
            this.alreadyLoggedInvalidCharacter = true;
        }
    }

    @Override
    public void newLine() {
        ++this.lines;
        if (!this.blankLine) {
            ++this.nonBlankLines;
        }
        this.blankLine = true;
    }

    @Override
    public void handleIgnoreEoL(char c) {
        if (!Character.isWhitespace(c)) {
            this.blankLine = false;
        }
    }

    @Override
    public void eof() {
        if (!this.blankLine) {
            ++this.nonBlankLines;
        }
    }

    public int lines() {
        return this.lines;
    }

    public int nonBlankLines() {
        return this.nonBlankLines;
    }
}

