/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.fs.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.Metadata;
import org.sonar.api.batch.fs.internal.charhandler.CharHandler;
import org.sonar.api.batch.fs.internal.charhandler.FileHashComputer;
import org.sonar.api.batch.fs.internal.charhandler.LineCounter;
import org.sonar.api.batch.fs.internal.charhandler.LineHashComputer;
import org.sonar.api.batch.fs.internal.charhandler.LineOffsetCounter;
import org.sonar.api.notifications.AnalysisWarnings;

@Immutable
public class FileMetadata {
    private static final char LINE_FEED = '\n';
    private static final char CARRIAGE_RETURN = '\r';
    private final AnalysisWarnings analysisWarnings;

    public FileMetadata(AnalysisWarnings analysisWarnings) {
        this.analysisWarnings = analysisWarnings;
    }

    public Metadata readMetadata(InputStream stream, Charset encoding, String filePath, @Nullable CharHandler otherHandler) {
        LineCounter lineCounter = new LineCounter(this.analysisWarnings, filePath, encoding);
        FileHashComputer fileHashComputer = new FileHashComputer(filePath);
        LineOffsetCounter lineOffsetCounter = new LineOffsetCounter();
        if (otherHandler != null) {
            CharHandler[] handlers = new CharHandler[]{lineCounter, fileHashComputer, lineOffsetCounter, otherHandler};
            FileMetadata.readFile(stream, encoding, filePath, handlers);
        } else {
            CharHandler[] handlers = new CharHandler[]{lineCounter, fileHashComputer, lineOffsetCounter};
            FileMetadata.readFile(stream, encoding, filePath, handlers);
        }
        return new Metadata(lineCounter.lines(), lineCounter.nonBlankLines(), fileHashComputer.getHash(), lineOffsetCounter.getOriginalLineStartOffsets(), lineOffsetCounter.getOriginalLineEndOffsets(), lineOffsetCounter.getLastValidOffset());
    }

    public Metadata readMetadata(InputStream stream, Charset encoding, String filePath) {
        return this.readMetadata(stream, encoding, filePath, null);
    }

    public Metadata readMetadata(Reader reader) {
        LineCounter lineCounter = new LineCounter(this.analysisWarnings, "fromString", StandardCharsets.UTF_16);
        FileHashComputer fileHashComputer = new FileHashComputer("fromString");
        LineOffsetCounter lineOffsetCounter = new LineOffsetCounter();
        CharHandler[] handlers = new CharHandler[]{lineCounter, fileHashComputer, lineOffsetCounter};
        try {
            FileMetadata.read(reader, handlers);
        }
        catch (IOException e) {
            throw new IllegalStateException("Should never occur", e);
        }
        return new Metadata(lineCounter.lines(), lineCounter.nonBlankLines(), fileHashComputer.getHash(), lineOffsetCounter.getOriginalLineStartOffsets(), lineOffsetCounter.getOriginalLineEndOffsets(), lineOffsetCounter.getLastValidOffset());
    }

    public static void readFile(InputStream stream, Charset encoding, String filePath, CharHandler[] handlers) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, encoding));){
            FileMetadata.read(reader, handlers);
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Fail to read file '%s' with encoding '%s'", filePath, encoding), e);
        }
    }

    private static void read(Reader reader, CharHandler[] handlers) throws IOException {
        int i2 = reader.read();
        boolean afterCR = false;
        while (i2 != -1) {
            char c = (char)i2;
            if (afterCR) {
                for (CharHandler handler : handlers) {
                    if (c == '\r') {
                        handler.newLine();
                        handler.handleAll(c);
                        continue;
                    }
                    if (c == '\n') {
                        handler.handleAll(c);
                        handler.newLine();
                        continue;
                    }
                    handler.newLine();
                    handler.handleIgnoreEoL(c);
                    handler.handleAll(c);
                }
                afterCR = c == '\r';
            } else if (c == '\n') {
                for (CharHandler handler : handlers) {
                    handler.handleAll(c);
                    handler.newLine();
                }
            } else if (c == '\r') {
                afterCR = true;
                for (CharHandler handler : handlers) {
                    handler.handleAll(c);
                }
            } else {
                for (CharHandler handler : handlers) {
                    handler.handleIgnoreEoL(c);
                    handler.handleAll(c);
                }
            }
            i2 = reader.read();
        }
        for (CharHandler handler : handlers) {
            if (afterCR) {
                handler.newLine();
            }
            handler.eof();
        }
    }

    public static void computeLineHashesForIssueTracking(InputFile f, LineHashConsumer consumer) {
        try {
            FileMetadata.readFile(f.inputStream(), f.charset(), f.absolutePath(), new CharHandler[]{new LineHashComputer(consumer, f.file())});
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to compute line hashes for " + f.absolutePath(), e);
        }
    }

    @FunctionalInterface
    public static interface LineHashConsumer {
        public void consume(int var1, @Nullable byte[] var2);
    }
}

