/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.fs.internal;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.StreamSupport;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputDir;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DefaultInputDir;
import org.sonar.api.batch.fs.internal.predicates.DefaultFilePredicates;
import org.sonar.api.batch.fs.internal.predicates.FileExtensionPredicate;
import org.sonar.api.batch.fs.internal.predicates.OptimizedFilePredicateAdapter;
import org.sonar.api.scan.filesystem.PathResolver;
import org.sonar.api.utils.PathUtils;

public class DefaultFileSystem
implements FileSystem {
    private final Cache cache;
    private final FilePredicates predicates;
    private final Path baseDir;
    private Path workDir;
    private Charset encoding;

    public DefaultFileSystem(Path baseDir) {
        this(baseDir, new MapCache(), new DefaultFilePredicates(baseDir));
    }

    public DefaultFileSystem(File baseDir) {
        this(baseDir.toPath(), new MapCache(), new DefaultFilePredicates(baseDir.toPath()));
    }

    protected DefaultFileSystem(Path baseDir, Cache cache, FilePredicates filePredicates) {
        this.baseDir = baseDir;
        this.cache = cache;
        this.predicates = filePredicates;
    }

    public Path baseDirPath() {
        return this.baseDir;
    }

    @Override
    public File baseDir() {
        return this.baseDir.toFile();
    }

    public DefaultFileSystem setEncoding(Charset e) {
        this.encoding = e;
        return this;
    }

    @Override
    public Charset encoding() {
        return this.encoding;
    }

    public DefaultFileSystem setWorkDir(Path d) {
        this.workDir = d;
        return this;
    }

    @Override
    public File workDir() {
        return this.workDir.toFile();
    }

    @Override
    public InputFile inputFile(FilePredicate predicate) {
        Iterable<InputFile> files = this.inputFiles(predicate);
        Iterator<InputFile> iterator2 = files.iterator();
        if (!iterator2.hasNext()) {
            return null;
        }
        InputFile first = iterator2.next();
        if (!iterator2.hasNext()) {
            return first;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("expected one element but was: <" + String.valueOf(first));
        for (int i2 = 0; i2 < 4 && iterator2.hasNext(); ++i2) {
            sb.append(", " + String.valueOf(iterator2.next()));
        }
        if (iterator2.hasNext()) {
            sb.append(", ...");
        }
        sb.append('>');
        throw new IllegalArgumentException(sb.toString());
    }

    public Iterable<InputFile> inputFiles() {
        return this.inputFiles(this.predicates.all());
    }

    @Override
    public Iterable<InputFile> inputFiles(FilePredicate predicate) {
        return OptimizedFilePredicateAdapter.create(predicate).get(this.cache);
    }

    @Override
    public boolean hasFiles(FilePredicate predicate) {
        return this.inputFiles(predicate).iterator().hasNext();
    }

    @Override
    public Iterable<File> files(FilePredicate predicate) {
        return () -> StreamSupport.stream(this.inputFiles(predicate).spliterator(), false).map(InputFile::file).iterator();
    }

    @Override
    public InputDir inputDir(File dir) {
        String relativePath = PathUtils.sanitize(new PathResolver().relativePath(this.baseDir.toFile(), dir));
        if (relativePath == null) {
            return null;
        }
        return new DefaultInputDir("unused", relativePath).setModuleBaseDir(this.baseDir);
    }

    public DefaultFileSystem add(InputFile inputFile) {
        this.cache.add(inputFile);
        return this;
    }

    @Override
    public SortedSet<String> languages() {
        return this.cache.languages();
    }

    @Override
    public FilePredicates predicates() {
        return this.predicates;
    }

    @Override
    public File resolvePath(String path) {
        File file = new File(path);
        if (!file.isAbsolute()) {
            try {
                file = new File(this.baseDir(), path).getCanonicalFile();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to resolve path '" + path + "'", e);
            }
        }
        return file;
    }

    private static class MapCache
    extends Cache {
        private final Map<String, InputFile> fileMap = new HashMap<String, InputFile>();
        private final Map<String, Set<InputFile>> filesByNameCache = new HashMap<String, Set<InputFile>>();
        private final Map<String, Set<InputFile>> filesByExtensionCache = new HashMap<String, Set<InputFile>>();
        private final SortedSet<String> languages = new TreeSet<String>();

        private MapCache() {
        }

        @Override
        public Iterable<InputFile> inputFiles() {
            return new ArrayList<InputFile>(this.fileMap.values());
        }

        @Override
        public InputFile inputFile(String relativePath) {
            return this.fileMap.get(relativePath);
        }

        @Override
        public Iterable<InputFile> getFilesByName(String filename) {
            return this.filesByNameCache.getOrDefault(filename, Collections.emptySet());
        }

        @Override
        public Iterable<InputFile> getFilesByExtension(String extension) {
            return this.filesByExtensionCache.getOrDefault(extension, Collections.emptySet());
        }

        @Override
        protected void doAdd(InputFile inputFile) {
            if (inputFile.language() != null) {
                this.languages.add(inputFile.language());
            }
            this.fileMap.put(inputFile.relativePath(), inputFile);
            this.filesByNameCache.computeIfAbsent(inputFile.filename(), x -> new HashSet()).add(inputFile);
            this.filesByExtensionCache.computeIfAbsent(FileExtensionPredicate.getExtension(inputFile), x -> new HashSet()).add(inputFile);
        }

        @Override
        protected SortedSet<String> languages() {
            return this.languages;
        }
    }

    public static abstract class Cache
    implements FileSystem.Index {
        protected abstract void doAdd(InputFile var1);

        final void add(InputFile inputFile) {
            this.doAdd(inputFile);
        }

        protected abstract SortedSet<String> languages();
    }
}

