/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util.io;

import java.text.MessageFormat;
import org.eclipse.jgit.internal.JGitText;

public final class InterruptTimer {
    private final AlarmState state = new AlarmState();
    private final AlarmThread thread;
    final AutoKiller autoKiller = new AutoKiller(this.state);

    public InterruptTimer() {
        this("JGit-InterruptTimer");
    }

    public InterruptTimer(String threadName) {
        this.thread = new AlarmThread(threadName, this.state);
        this.thread.start();
    }

    public void begin(int timeout2) {
        if (timeout2 <= 0) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidTimeout, timeout2));
        }
        Thread.interrupted();
        this.state.begin(timeout2);
    }

    public void end() {
        this.state.end();
    }

    public void terminate() {
        this.state.terminate();
        boolean interrupted = false;
        while (true) {
            try {
                this.thread.join();
                return;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    static final class AlarmState
    implements Runnable {
        private Thread callingThread = Thread.currentThread();
        private int lastTimeout;
        private long deadline;
        private boolean terminated;

        AlarmState() {
        }

        @Override
        public synchronized void run() {
            while (!this.terminated && this.callingThread.isAlive()) {
                try {
                    if (this.deadline > 0L) {
                        long delay = this.deadline - AlarmState.now();
                        if (delay <= 0L) {
                            this.deadline = 0L;
                            this.callingThread.interrupt();
                            continue;
                        }
                        this.wait(delay);
                        continue;
                    }
                    this.wait(this.lastTimeout == 0 ? 1000 : this.lastTimeout);
                    this.lastTimeout = 0;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        synchronized void begin(int timeout2) {
            if (this.terminated) {
                throw new IllegalStateException(JGitText.get().timerAlreadyTerminated);
            }
            this.callingThread = Thread.currentThread();
            this.deadline = AlarmState.now() + (long)timeout2;
            if (this.lastTimeout != timeout2) {
                boolean isNotify = this.lastTimeout == 0 || this.lastTimeout > timeout2;
                this.lastTimeout = timeout2;
                if (isNotify) {
                    this.notifyAll();
                }
            }
        }

        synchronized void end() {
            if (0L == this.deadline) {
                Thread.interrupted();
            } else {
                this.deadline = 0L;
            }
        }

        synchronized void terminate() {
            if (!this.terminated) {
                this.deadline = 0L;
                this.terminated = true;
                this.notifyAll();
            }
        }

        private static long now() {
            return System.currentTimeMillis();
        }
    }

    static final class AlarmThread
    extends Thread {
        AlarmThread(String name, AlarmState q) {
            super(q);
            this.setName(name);
            this.setDaemon(true);
        }
    }

    private static final class AutoKiller {
        private final AlarmState state;

        AutoKiller(AlarmState s) {
            this.state = s;
        }

        protected void finalize() throws Throwable {
            this.state.terminate();
        }
    }
}

