/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.text.MessageFormat;
import java.text.Normalizer;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Random;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.SystemReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger LOG = LoggerFactory.getLogger(FileUtils.class);
    private static final Random RNG = new Random();
    public static final int NONE = 0;
    public static final int RECURSIVE = 1;
    public static final int RETRY = 2;
    public static final int SKIP_MISSING = 4;
    public static final int IGNORE_ERRORS = 8;
    public static final int EMPTY_DIRECTORIES_ONLY = 16;

    public static Path toPath(File f) throws IOException {
        try {
            return f.toPath();
        }
        catch (InvalidPathException ex) {
            throw new IOException(ex);
        }
    }

    public static void delete(File f) throws IOException {
        FileUtils.delete(f, 0);
    }

    /*
     * Unable to fully structure code
     */
    public static void delete(File f, int options) throws IOException {
        fs = FS.DETECTED;
        if ((options & 4) != 0 && !fs.exists(f)) {
            return;
        }
        if ((options & 1) != 0 && fs.isDirectory(f) && (items = f.listFiles()) != null) {
            files = new ArrayList<File>();
            dirs = new ArrayList<File>();
            var9_7 = items;
            var8_8 = items.length;
            var7_11 = 0;
            while (var7_11 < var8_8) {
                c = var9_7[var7_11];
                if (c.isFile()) {
                    files.add(c);
                } else {
                    dirs.add(c);
                }
                ++var7_11;
            }
            for (File file : files) {
                FileUtils.delete(file, options);
            }
            for (File d : dirs) {
                FileUtils.delete(d, options);
            }
        }
        delete = false;
        if ((options & 16) != 0) {
            if (f.isDirectory()) {
                delete = true;
            } else if ((options & 8) == 0) {
                throw new IOException(MessageFormat.format(JGitText.get().deleteFileFailed, new Object[]{f.getAbsolutePath()}));
            }
        } else {
            delete = true;
        }
        if (delete) {
            t = null;
            p = f.toPath();
            while (true) {
                tryAgain = false;
                try {
                    Files.delete(p);
                    return;
                }
                catch (FileNotFoundException | NoSuchFileException e) {
                    FileUtils.handleDeleteException(f, e, options, 12);
                    return;
                }
                catch (DirectoryNotEmptyException e) {
                    FileUtils.handleDeleteException(f, e, options, 8);
                    return;
                }
                catch (IOException e) {
                    if (!f.canWrite()) {
                        tryAgain = f.setWritable(true);
                    }
                    if (!tryAgain) {
                        t = e;
                    }
                    if (tryAgain) continue;
                    if ((options & 2) == 0) break;
                    i = 1;
                    ** while (i < 10)
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException var8_9) {
                        // empty catch block
                    }
                    try {
                        Files.deleteIfExists(p);
                        return;
                    }
                    catch (IOException e) {
                        t = e;
                        ++i;
                    }
                    continue;
                }
                break;
            }
lbl71:
            // 2 sources

            FileUtils.handleDeleteException(f, t, options, 8);
        }
    }

    private static void handleDeleteException(File f, IOException e, int allOptions, int checkOptions) throws IOException {
        if (e != null && (allOptions & checkOptions) == 0) {
            throw new IOException(MessageFormat.format(JGitText.get().deleteFileFailed, f.getAbsolutePath()), e);
        }
    }

    public static void rename(File src, File dst) throws IOException {
        FileUtils.rename(src, dst, StandardCopyOption.REPLACE_EXISTING);
    }

    public static void rename(File src, File dst, CopyOption ... options) throws AtomicMoveNotSupportedException, IOException {
        int attempts = FS.DETECTED.retryFailedLockFileCommit() ? 10 : 1;
        IOException finalError = null;
        while (--attempts >= 0) {
            try {
                Files.move(FileUtils.toPath(src), FileUtils.toPath(dst), options);
                return;
            }
            catch (AtomicMoveNotSupportedException e) {
                throw e;
            }
            catch (IOException e) {
                if (attempts == 0) {
                    try {
                        if (!dst.delete()) {
                            FileUtils.delete(dst, 17);
                        }
                        Files.move(FileUtils.toPath(src), FileUtils.toPath(dst), options);
                        return;
                    }
                    catch (IOException e2) {
                        e2.addSuppressed(e);
                        finalError = e2;
                    }
                }
                if (attempts <= 0) continue;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e2) {
                    throw new IOException(MessageFormat.format(JGitText.get().renameFileFailed, src.getAbsolutePath(), dst.getAbsolutePath()), e2);
                }
            }
        }
        throw new IOException(MessageFormat.format(JGitText.get().renameFileFailed, src.getAbsolutePath(), dst.getAbsolutePath()), finalError);
    }

    public static void mkdir(File d) throws IOException {
        FileUtils.mkdir(d, false);
    }

    public static void mkdir(File d, boolean skipExisting) throws IOException {
        if (!d.mkdir()) {
            if (skipExisting && d.isDirectory()) {
                return;
            }
            throw new IOException(MessageFormat.format(JGitText.get().mkDirFailed, d.getAbsolutePath()));
        }
    }

    public static void mkdirs(File d) throws IOException {
        FileUtils.mkdirs(d, false);
    }

    public static void mkdirs(File d, boolean skipExisting) throws IOException {
        if (!d.mkdirs()) {
            if (skipExisting && d.isDirectory()) {
                return;
            }
            throw new IOException(MessageFormat.format(JGitText.get().mkDirsFailed, d.getAbsolutePath()));
        }
    }

    public static void createNewFile(File f) throws IOException {
        if (!f.createNewFile()) {
            throw new IOException(MessageFormat.format(JGitText.get().createNewFileFailed, f));
        }
    }

    public static Path createSymLink(File path, String target) throws IOException {
        Path nioPath = FileUtils.toPath(path);
        if (Files.exists(nioPath, LinkOption.NOFOLLOW_LINKS)) {
            BasicFileAttributes attrs = Files.readAttributes(nioPath, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
            if (attrs.isRegularFile() || attrs.isSymbolicLink()) {
                FileUtils.delete(path);
            } else {
                FileUtils.delete(path, 17);
            }
        }
        if (SystemReader.getInstance().isWindows()) {
            target = target.replace('/', '\\');
        }
        Path nioTarget = FileUtils.toPath(new File(target));
        return Files.createSymbolicLink(nioPath, nioTarget, new FileAttribute[0]);
    }

    public static String readSymLink(File path) throws IOException {
        Path nioPath = FileUtils.toPath(path);
        Path target = Files.readSymbolicLink(nioPath);
        String targetString = target.toString();
        if (SystemReader.getInstance().isWindows()) {
            targetString = targetString.replace('\\', '/');
        } else if (SystemReader.getInstance().isMacOS()) {
            targetString = Normalizer.normalize(targetString, Normalizer.Form.NFC);
        }
        return targetString;
    }

    public static File createTempDir(String prefix, String suffix, File dir) throws IOException {
        boolean RETRIES = true;
        int i2 = 0;
        while (i2 < 1) {
            File tmp = File.createTempFile(prefix, suffix, dir);
            if (tmp.delete() && tmp.mkdir()) {
                return tmp;
            }
            ++i2;
        }
        throw new IOException(JGitText.get().cannotCreateTempDir);
    }

    public static String relativizeNativePath(String base, String other) {
        return FS.DETECTED.relativize(base, other);
    }

    public static String relativizeGitPath(String base, String other) {
        return FileUtils.relativizePath(base, other, "/", false);
    }

    public static String relativizePath(String base, String other, String dirSeparator, boolean caseSensitive) {
        if (base.equals(other)) {
            return "";
        }
        String[] baseSegments = base.split(Pattern.quote(dirSeparator));
        String[] otherSegments = other.split(Pattern.quote(dirSeparator));
        int commonPrefix = 0;
        while (commonPrefix < baseSegments.length && commonPrefix < otherSegments.length) {
            if (caseSensitive && baseSegments[commonPrefix].equals(otherSegments[commonPrefix])) {
                ++commonPrefix;
                continue;
            }
            if (caseSensitive || !baseSegments[commonPrefix].equalsIgnoreCase(otherSegments[commonPrefix])) break;
            ++commonPrefix;
        }
        StringBuilder builder = new StringBuilder();
        int i2 = commonPrefix;
        while (i2 < baseSegments.length) {
            builder.append("..").append(dirSeparator);
            ++i2;
        }
        i2 = commonPrefix;
        while (i2 < otherSegments.length) {
            builder.append(otherSegments[i2]);
            if (i2 < otherSegments.length - 1) {
                builder.append(dirSeparator);
            }
            ++i2;
        }
        return builder.toString();
    }

    public static boolean isStaleFileHandle(IOException ioe) {
        String msg = ioe.getMessage();
        return msg != null && msg.toLowerCase(Locale.ROOT).matches("stale .*file .*handle");
    }

    public static boolean isStaleFileHandleInCausalChain(Throwable throwable) {
        while (throwable != null) {
            if (throwable instanceof IOException && FileUtils.isStaleFileHandle((IOException)throwable)) {
                return true;
            }
            throwable = throwable.getCause();
        }
        return false;
    }

    private static void backOff(long delay, IOException cause) throws IOException {
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException e) {
            InterruptedIOException interruption = new InterruptedIOException();
            interruption.initCause(e);
            interruption.addSuppressed(cause);
            Thread.currentThread().interrupt();
            throw interruption;
        }
    }

    public static <T> T readWithRetries(File file, IOFunction<File, ? extends T> reader) throws Exception {
        int maxStaleRetries = 5;
        int retries = 0;
        long backoff = 50L;
        while (true) {
            try {
                while (true) {
                    try {
                        return reader.apply(file);
                    }
                    catch (IOException e) {
                        if (FileUtils.isStaleFileHandleInCausalChain(e) && retries < maxStaleRetries) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug(MessageFormat.format(JGitText.get().packedRefsHandleIsStale, retries), e);
                            }
                            ++retries;
                            continue;
                        }
                        throw e;
                    }
                    break;
                }
            }
            catch (FileNotFoundException noFile) {
                if (!file.isFile()) {
                    return null;
                }
                if (backoff > 1000L) {
                    throw noFile;
                }
                FileUtils.backOff(backoff, noFile);
                backoff *= 2L;
                continue;
            }
            break;
        }
    }

    static boolean isSymlink(File file) {
        return Files.isSymbolicLink(file.toPath());
    }

    static Instant lastModifiedInstant(Path path) {
        try {
            return Files.getLastModifiedTime(path, LinkOption.NOFOLLOW_LINKS).toInstant();
        }
        catch (NoSuchFileException e) {
            LOG.debug("Cannot read lastModifiedInstant since path {} does not exist", (Object)path);
            return Instant.EPOCH;
        }
        catch (IOException e) {
            LOG.error(MessageFormat.format(JGitText.get().readLastModifiedFailed, path), e);
            return Instant.ofEpochMilli(path.toFile().lastModified());
        }
    }

    static BasicFileAttributes fileAttributes(File file) throws IOException {
        return Files.readAttributes(file.toPath(), BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
    }

    static void setLastModified(Path path, Instant time) throws IOException {
        Files.setLastModifiedTime(path, FileTime.from(time));
    }

    static boolean exists(File file) {
        return Files.exists(file.toPath(), LinkOption.NOFOLLOW_LINKS);
    }

    static boolean isHidden(File file) throws IOException {
        return Files.isHidden(FileUtils.toPath(file));
    }

    public static void setHidden(File file, boolean hidden) throws IOException {
        Files.setAttribute(FileUtils.toPath(file), "dos:hidden", hidden, LinkOption.NOFOLLOW_LINKS);
    }

    public static long getLength(File file) throws IOException {
        Path nioPath = FileUtils.toPath(file);
        if (Files.isSymbolicLink(nioPath)) {
            return Files.readSymbolicLink(nioPath).toString().getBytes(StandardCharsets.UTF_8).length;
        }
        return Files.size(nioPath);
    }

    static boolean isDirectory(File file) {
        return Files.isDirectory(file.toPath(), LinkOption.NOFOLLOW_LINKS);
    }

    static boolean isFile(File file) {
        return Files.isRegularFile(file.toPath(), LinkOption.NOFOLLOW_LINKS);
    }

    public static boolean hasFiles(Path dir) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Stream<Path> stream = Files.list(dir);){
            return stream.findAny().isPresent();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static boolean canExecute(File file) {
        if (!FileUtils.isFile(file)) {
            return false;
        }
        return Files.isExecutable(file.toPath());
    }

    static FS.Attributes getFileAttributesBasic(FS fs, File file) {
        try {
            Path nioPath = FileUtils.toPath(file);
            BasicFileAttributes readAttributes = nioPath.getFileSystem().provider().getFileAttributeView(nioPath, BasicFileAttributeView.class, LinkOption.NOFOLLOW_LINKS).readAttributes();
            FS.Attributes attributes = new FS.Attributes(fs, file, true, readAttributes.isDirectory(), fs.supportsExecute() ? file.canExecute() : false, readAttributes.isSymbolicLink(), readAttributes.isRegularFile(), readAttributes.creationTime().toMillis(), readAttributes.lastModifiedTime().toInstant(), readAttributes.isSymbolicLink() ? (long)Constants.encode(FileUtils.readSymLink(file)).length : readAttributes.size());
            return attributes;
        }
        catch (IOException e) {
            return new FS.Attributes(file, fs);
        }
    }

    public static FS.Attributes getFileAttributesPosix(FS fs, File file) {
        try {
            Path nioPath = FileUtils.toPath(file);
            PosixFileAttributes readAttributes = nioPath.getFileSystem().provider().getFileAttributeView(nioPath, PosixFileAttributeView.class, LinkOption.NOFOLLOW_LINKS).readAttributes();
            FS.Attributes attributes = new FS.Attributes(fs, file, true, readAttributes.isDirectory(), readAttributes.permissions().contains((Object)PosixFilePermission.OWNER_EXECUTE), readAttributes.isSymbolicLink(), readAttributes.isRegularFile(), readAttributes.creationTime().toMillis(), readAttributes.lastModifiedTime().toInstant(), readAttributes.size());
            return attributes;
        }
        catch (IOException e) {
            return new FS.Attributes(file, fs);
        }
    }

    public static File normalize(File file) {
        if (SystemReader.getInstance().isMacOS()) {
            String normalized = Normalizer.normalize(file.getPath(), Normalizer.Form.NFC);
            return new File(normalized);
        }
        return file;
    }

    public static String normalize(String name) {
        if (SystemReader.getInstance().isMacOS()) {
            if (name == null) {
                return null;
            }
            return Normalizer.normalize(name, Normalizer.Form.NFC);
        }
        return name;
    }

    public static File canonicalize(File file) {
        if (file == null) {
            return null;
        }
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            return file;
        }
    }

    public static String pathToString(File file) {
        String path = file.getPath();
        if (SystemReader.getInstance().isWindows()) {
            return path.replace('\\', '/');
        }
        return path;
    }

    public static void touch(Path f) throws IOException {
        Throwable throwable = null;
        Object var2_2 = null;
        try {
            FileChannel fc = FileChannel.open(f, StandardOpenOption.CREATE, StandardOpenOption.APPEND, StandardOpenOption.SYNC);
            if (fc != null) {
                fc.close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Files.setLastModifiedTime(f, FileTime.from(Instant.now()));
    }

    public static long delay(long last, long min, long max) {
        long r = Math.max(0L, last * 3L - min);
        if (r > 0L) {
            int c = (int)Math.min(r + 1L, Integer.MAX_VALUE);
            r = RNG.nextInt(c);
        }
        return Math.max(Math.min(min + r, max), min);
    }

    @FunctionalInterface
    public static interface IOFunction<A, B> {
        public B apply(A var1) throws Exception;
    }
}

