/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.text.MessageFormat;
import java.util.AbstractList;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.revwalk.RevObject;

public class RevObjectList<E extends RevObject>
extends AbstractList<E> {
    static final int BLOCK_SHIFT = 8;
    static final int BLOCK_SIZE = 256;
    protected Block contents = new Block(0);
    protected int size = 0;

    @Override
    public void add(int index, E element) {
        if (index != this.size) {
            throw new UnsupportedOperationException(MessageFormat.format(JGitText.get().unsupportedOperationNotAddAtEnd, index));
        }
        this.set(index, element);
        ++this.size;
    }

    @Override
    public E set(int index, E element) {
        Block s = this.contents;
        while (index >> s.shift >= 256) {
            s = new Block(s.shift + 8);
            s.contents[0] = this.contents;
            this.contents = s;
        }
        while (s.shift > 0) {
            int i2 = index >> s.shift;
            index -= i2 << s.shift;
            if (s.contents[i2] == null) {
                s.contents[i2] = new Block(s.shift - 8);
            }
            s = (Block)s.contents[i2];
        }
        Object old = s.contents[index];
        s.contents[index] = element;
        return (E)((RevObject)old);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public E get(int index) {
        s = this.contents;
        if (index >> s.shift < 1024) ** GOTO lbl7
        return null;
lbl-1000:
        // 1 sources

        {
            i = index >> s.shift;
            index -= i << s.shift;
            s = (Block)s.contents[i];
lbl7:
            // 2 sources

            ** while (s != null && s.shift > 0)
        }
lbl8:
        // 1 sources

        return (E)(s != null ? (RevObject)s.contents[index] : null);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.contents = new Block(0);
        this.size = 0;
    }

    protected static class Block {
        final Object[] contents = new Object[256];
        final int shift;

        Block(int s) {
            this.shift = s;
        }
    }
}

