/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.patch;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.zip.InflaterInputStream;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.api.errors.FilterFailedException;
import org.eclipse.jgit.attributes.Attribute;
import org.eclipse.jgit.attributes.Attributes;
import org.eclipse.jgit.attributes.FilterCommand;
import org.eclipse.jgit.attributes.FilterCommandRegistry;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IndexWriteException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.CoreConfig;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.FileModeCache;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.patch.BinaryHunk;
import org.eclipse.jgit.patch.FileHeader;
import org.eclipse.jgit.patch.HunkHeader;
import org.eclipse.jgit.patch.Patch;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeOptions;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.NotIgnoredFilter;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.LfsFactory;
import org.eclipse.jgit.util.RawParseUtils;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.jgit.util.SystemReader;
import org.eclipse.jgit.util.TemporaryBuffer;
import org.eclipse.jgit.util.io.BinaryDeltaInputStream;
import org.eclipse.jgit.util.io.BinaryHunkInputStream;
import org.eclipse.jgit.util.io.CountingOutputStream;
import org.eclipse.jgit.util.io.EolStreamTypeUtil;
import org.eclipse.jgit.util.sha1.SHA1;

public class PatchApplier {
    private static final byte[] NO_EOL = "\\ No newline at end of file".getBytes(StandardCharsets.US_ASCII);
    @Nullable
    private final RevTree beforeTree;
    private final Repository repo;
    private final ObjectInserter inserter;
    private final ObjectReader reader;
    private final Charset charset;
    private WorkingTreeOptions workingTreeOptions;
    private int inCoreSizeLimit;
    private boolean allowConflicts;
    private static final int FILE_TREE_INDEX = 1;

    public PatchApplier(Repository repo) {
        this.repo = repo;
        this.inserter = repo.newObjectInserter();
        this.reader = this.inserter.newReader();
        this.beforeTree = null;
        this.allowConflicts = false;
        this.charset = StandardCharsets.UTF_8;
        StoredConfig config = repo.getConfig();
        this.workingTreeOptions = config.get(WorkingTreeOptions.KEY);
        this.inCoreSizeLimit = config.getInt("merge", "inCoreLimit", 0xA00000);
    }

    public PatchApplier(Repository repo, RevTree beforeTree, ObjectInserter oi) {
        this.repo = repo;
        this.beforeTree = beforeTree;
        this.inserter = oi;
        this.reader = oi.newReader();
        this.allowConflicts = false;
        this.charset = StandardCharsets.UTF_8;
    }

    /*
     * WARNING - void declaration
     */
    public Result applyPatch(Patch p) throws IOException {
        void var7_10;
        Result result = new Result();
        DirCache dirCache = this.inCore() ? DirCache.read(this.reader, this.beforeTree) : this.repo.lockDirCache();
        FileModeCache directoryCache = new FileModeCache(this.repo);
        DirCacheBuilder dirCacheBuilder = dirCache.builder();
        HashSet<String> modifiedPaths = new HashSet<String>();
        for (FileHeader fileHeader : p.getFiles()) {
            File dest;
            DiffEntry.ChangeType type = fileHeader.getChangeType();
            File src = this.getFile(fileHeader.getOldPath());
            if (!this.verifyExistence(fileHeader, src, dest = this.getFile(fileHeader.getNewPath()), result)) continue;
            switch (type) {
                case ADD: {
                    if (dest != null) {
                        directoryCache.safeCreateParentDirectory(fileHeader.getNewPath(), dest.getParentFile(), false);
                        FileUtils.createNewFile(dest);
                    }
                    this.apply(fileHeader.getNewPath(), dirCache, dirCacheBuilder, dest, fileHeader, result);
                    break;
                }
                case MODIFY: {
                    this.apply(fileHeader.getOldPath(), dirCache, dirCacheBuilder, src, fileHeader, result);
                    break;
                }
                case DELETE: {
                    if (this.inCore() || src.delete()) break;
                    throw new IOException(MessageFormat.format(JGitText.get().cannotDeleteFile, src));
                }
                case RENAME: {
                    if (!this.inCore()) {
                        directoryCache.safeCreateParentDirectory(fileHeader.getNewPath(), dest.getParentFile(), false);
                        FileUtils.rename(src, dest, StandardCopyOption.ATOMIC_MOVE);
                    }
                    String pathWithOriginalContent = this.inCore() ? fileHeader.getOldPath() : fileHeader.getNewPath();
                    this.apply(pathWithOriginalContent, dirCache, dirCacheBuilder, dest, fileHeader, result);
                    break;
                }
                case COPY: {
                    if (!this.inCore()) {
                        directoryCache.safeCreateParentDirectory(fileHeader.getNewPath(), dest.getParentFile(), false);
                        Files.copy(src.toPath(), dest.toPath(), new CopyOption[0]);
                    }
                    this.apply(fileHeader.getOldPath(), dirCache, dirCacheBuilder, dest, fileHeader, result);
                }
            }
            if (fileHeader.getChangeType() != DiffEntry.ChangeType.DELETE) {
                modifiedPaths.add(fileHeader.getNewPath());
            }
            if (fileHeader.getChangeType() == DiffEntry.ChangeType.COPY || fileHeader.getChangeType() == DiffEntry.ChangeType.ADD) continue;
            modifiedPaths.add(fileHeader.getOldPath());
        }
        boolean bl = false;
        while (var7_10 < dirCache.getEntryCount()) {
            DirCacheEntry dce = dirCache.getEntry((int)var7_10);
            if (!modifiedPaths.contains(dce.getPathString()) || dce.getStage() != 0) {
                dirCacheBuilder.add(dce);
            }
            ++var7_10;
        }
        if (this.inCore()) {
            dirCacheBuilder.finish();
        } else if (!dirCacheBuilder.commit()) {
            throw new IndexWriteException();
        }
        result.treeId = dirCache.writeTree(this.inserter);
        result.paths = modifiedPaths.stream().sorted().collect(Collectors.toList());
        return result;
    }

    public PatchApplier allowConflicts() {
        this.allowConflicts = true;
        return this;
    }

    private File getFile(String path) {
        return this.inCore() ? null : new File(this.repo.getWorkTree(), path);
    }

    @Nullable
    private TreeWalk getTreeWalkForFile(String path, DirCache cache) throws IOException {
        if (this.inCore()) {
            return TreeWalk.forPath(this.repo, path, this.beforeTree);
        }
        TreeWalk walk = new TreeWalk(this.repo);
        int cacheTreeIdx = walk.addTree(new DirCacheIterator(cache));
        FileTreeIterator files = new FileTreeIterator(this.repo);
        if (1 != walk.addTree(files)) {
            throw new IllegalStateException();
        }
        walk.setFilter(AndTreeFilter.create(PathFilterGroup.createFromStrings(path), new NotIgnoredFilter(1)));
        walk.setOperationType(TreeWalk.OperationType.CHECKIN_OP);
        walk.setRecursive(true);
        files.setDirCacheIterator(walk, cacheTreeIdx);
        return walk;
    }

    private boolean fileExists(String path, @Nullable File f) throws IOException {
        if (f != null) {
            return f.exists();
        }
        return this.inCore() && TreeWalk.forPath(this.repo, path, this.beforeTree) != null;
    }

    private boolean verifyExistence(FileHeader fh, File src, File dest, Result result) throws IOException {
        boolean isValid = true;
        boolean srcShouldExist = List.of(DiffEntry.ChangeType.MODIFY, DiffEntry.ChangeType.DELETE, DiffEntry.ChangeType.RENAME, DiffEntry.ChangeType.COPY).contains((Object)fh.getChangeType());
        boolean destShouldNotExist = List.of(DiffEntry.ChangeType.ADD, DiffEntry.ChangeType.RENAME, DiffEntry.ChangeType.COPY).contains((Object)fh.getChangeType());
        if (srcShouldExist != this.fileExists(fh.getOldPath(), src)) {
            result.addError(MessageFormat.format(srcShouldExist ? JGitText.get().applyPatchWithSourceOnNonExistentSource : JGitText.get().applyPatchWithoutSourceOnAlreadyExistingSource, new Object[]{fh.getPatchType()}), fh.getOldPath(), null);
            isValid = false;
        }
        if (destShouldNotExist && this.fileExists(fh.getNewPath(), dest)) {
            result.addError(MessageFormat.format(JGitText.get().applyPatchWithCreationOverAlreadyExistingDestination, new Object[]{fh.getPatchType()}), fh.getNewPath(), null);
            isValid = false;
        }
        if (srcShouldExist && !this.validGitPath(fh.getOldPath())) {
            result.addError(JGitText.get().applyPatchSourceInvalid, fh.getOldPath(), null);
            isValid = false;
        }
        if (destShouldNotExist && !this.validGitPath(fh.getNewPath())) {
            result.addError(JGitText.get().applyPatchDestInvalid, fh.getNewPath(), null);
            isValid = false;
        }
        return isValid;
    }

    private boolean validGitPath(String path) {
        try {
            SystemReader.getInstance().checkPath(path);
            return true;
        }
        catch (CorruptObjectException e) {
            return false;
        }
    }

    private void apply(String pathWithOriginalContent, DirCache dirCache, DirCacheBuilder dirCacheBuilder, @Nullable File f, FileHeader fh, Result result) throws IOException {
        ContentStreamLoader resultStreamLoader;
        FileMode fileMode;
        if (FileHeader.PatchType.BINARY.equals((Object)fh.getPatchType())) {
            return;
        }
        TreeWalk walk = this.getTreeWalkForFile(pathWithOriginalContent, dirCache);
        boolean loadedFromTreeWalk = false;
        boolean convertCrLf = this.inCore() || this.needsCrLfConversion(f, fh);
        CoreConfig.EolStreamType streamType = convertCrLf ? CoreConfig.EolStreamType.TEXT_CRLF : CoreConfig.EolStreamType.DIRECT;
        String smudgeFilterCommand = null;
        DirCacheCheckout.StreamSupplier fileStreamSupplier = null;
        ObjectId fileId = ObjectId.zeroId();
        if (walk != null) {
            if (this.inCore()) {
                fileId = walk.getObjectId(0);
                ObjectLoader loader = LfsFactory.getInstance().applySmudgeFilter(this.repo, this.reader.open(fileId, 3), null);
                byte[] data = loader.getBytes();
                convertCrLf = RawText.isCrLfText(data);
                fileStreamSupplier = () -> new ByteArrayInputStream(data);
                streamType = convertCrLf ? CoreConfig.EolStreamType.TEXT_CRLF : CoreConfig.EolStreamType.DIRECT;
                smudgeFilterCommand = walk.getFilterCommand("smudge");
                loadedFromTreeWalk = true;
            } else if (walk.next()) {
                streamType = convertCrLf ? CoreConfig.EolStreamType.TEXT_CRLF : walk.getEolStreamType(TreeWalk.OperationType.CHECKOUT_OP);
                smudgeFilterCommand = walk.getFilterCommand("smudge");
                FileTreeIterator file = walk.getTree(1, FileTreeIterator.class);
                if (file != null) {
                    fileId = file.getEntryObjectId();
                    fileStreamSupplier = file::openEntryStream;
                    loadedFromTreeWalk = true;
                } else {
                    throw new IOException(MessageFormat.format(JGitText.get().cannotReadFile, pathWithOriginalContent));
                }
            }
        }
        if (fileStreamSupplier == null) {
            fileStreamSupplier = this.inCore() ? InputStream::nullInputStream : () -> new FileInputStream(f);
        }
        FileMode fileMode2 = fileMode = fh.getNewMode() != null ? fh.getNewMode() : FileMode.REGULAR_FILE;
        if (FileHeader.PatchType.GIT_BINARY.equals((Object)fh.getPatchType())) {
            resultStreamLoader = this.applyBinary(pathWithOriginalContent, f, fh, fileStreamSupplier, fileId, result);
        } else {
            String filterCommand = walk != null ? walk.getFilterCommand("clean") : null;
            RawText raw = this.getRawText(f, fileStreamSupplier, fileId, pathWithOriginalContent, loadedFromTreeWalk, filterCommand, convertCrLf);
            resultStreamLoader = this.applyText(raw, fh, result);
        }
        if (resultStreamLoader == null || !result.getErrors().isEmpty() && result.getErrors().stream().anyMatch(e -> !e.msg.equals("cannot apply hunk"))) {
            return;
        }
        if (f != null) {
            TemporaryBuffer.LocalFile buffer = new TemporaryBuffer.LocalFile(null);
            try {
                DirCacheCheckout.CheckoutMetadata metadata = new DirCacheCheckout.CheckoutMetadata(streamType, smudgeFilterCommand);
                Throwable throwable = null;
                Object var19_21 = null;
                try (TemporaryBuffer.LocalFile buf = buffer;){
                    DirCacheCheckout.getContent(this.repo, pathWithOriginalContent, metadata, resultStreamLoader.supplier, this.workingTreeOptions, (OutputStream)buf);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                throwable = null;
                var19_21 = null;
                try (InputStream bufIn = ((TemporaryBuffer)buffer).openInputStream();){
                    Files.copy(bufIn, f.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            finally {
                ((TemporaryBuffer)buffer).destroy();
            }
            this.repo.getFS().setExecute(f, fileMode == FileMode.EXECUTABLE_FILE);
        }
        Instant lastModified = f == null ? null : this.repo.getFS().lastModifiedInstant(f);
        Attributes attributes = walk != null ? walk.getAttributes() : new Attributes(new Attribute[0]);
        DirCacheEntry dce = this.insertToIndex(resultStreamLoader.supplier.load(), fh.getNewPath().getBytes(StandardCharsets.UTF_8), fileMode, lastModified, resultStreamLoader.length, attributes.get("filter"));
        dirCacheBuilder.add(dce);
        if (FileHeader.PatchType.GIT_BINARY.equals((Object)fh.getPatchType()) && fh.getNewId() != null && fh.getNewId().isComplete() && !fh.getNewId().toObjectId().equals(dce.getObjectId())) {
            result.addError(MessageFormat.format(JGitText.get().applyBinaryResultOidWrong, pathWithOriginalContent), fh.getOldPath(), null);
        }
    }

    private DirCacheEntry insertToIndex(InputStream input, byte[] path, FileMode fileMode, Instant lastModified, long length, Attribute lfsAttribute) throws IOException {
        DirCacheEntry dce = new DirCacheEntry(path, 0);
        dce.setFileMode(fileMode);
        if (lastModified != null) {
            dce.setLastModified(lastModified);
        }
        dce.setLength(length);
        Throwable throwable = null;
        Object var10_10 = null;
        try (LfsFactory.LfsInputStream is = LfsFactory.getInstance().applyCleanFilter(this.repo, input, length, lfsAttribute);){
            dce.setObjectId(this.inserter.insert(3, is.getLength(), is));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return dce;
    }

    private RawText getRawText(@Nullable File file, DirCacheCheckout.StreamSupplier fileStreamSupplier, ObjectId fileId, String path, boolean fromTreeWalk, String filterCommand, boolean convertCrLf) throws IOException {
        if (fromTreeWalk) {
            Throwable throwable = null;
            Object var9_12 = null;
            try (InputStream input = this.filterClean(this.repo, path, fileStreamSupplier.load(), convertCrLf, filterCommand);){
                return new RawText(IO.readWholeStream(input, 0).array());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        if (convertCrLf) {
            Throwable throwable = null;
            Object var9_14 = null;
            try (InputStream input = EolStreamTypeUtil.wrapInputStream(fileStreamSupplier.load(), CoreConfig.EolStreamType.TEXT_LF);){
                return new RawText(IO.readWholeStream(input, 0).array());
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        if (this.inCore() && fileId.equals(ObjectId.zeroId())) {
            return new RawText(new byte[0]);
        }
        return new RawText(file);
    }

    private InputStream filterClean(Repository repository, String path, InputStream fromFile, boolean convertCrLf, String filterCommand) throws IOException {
        FS.ExecutionResult result;
        InputStream input = fromFile;
        if (convertCrLf) {
            input = EolStreamTypeUtil.wrapInputStream(input, CoreConfig.EolStreamType.TEXT_LF);
        }
        if (StringUtils.isEmptyOrNull(filterCommand)) {
            return input;
        }
        if (FilterCommandRegistry.isRegistered(filterCommand)) {
            TemporaryBuffer.LocalFile buffer = new TemporaryBuffer.LocalFile(null, this.inCoreSizeLimit);
            FilterCommand command = FilterCommandRegistry.createFilterCommand(filterCommand, repository, input, buffer);
            while (command.run() != -1) {
            }
            return buffer.openInputStreamWithAutoDestroy();
        }
        FS fs = repository.getFS();
        ProcessBuilder filterProcessBuilder = fs.runInShell(filterCommand, new String[0]);
        filterProcessBuilder.directory(repository.getWorkTree());
        filterProcessBuilder.environment().put("GIT_DIR", repository.getDirectory().getAbsolutePath());
        try {
            result = fs.execute(filterProcessBuilder, input);
        }
        catch (IOException | InterruptedException e) {
            throw new IOException(new FilterFailedException(e, filterCommand, path));
        }
        int rc = result.getRc();
        if (rc != 0) {
            throw new IOException(new FilterFailedException(rc, filterCommand, path, result.getStdout().toByteArray(4096), RawParseUtils.decode(result.getStderr().toByteArray(4096))));
        }
        return result.getStdout().openInputStreamWithAutoDestroy();
    }

    private boolean needsCrLfConversion(File f, FileHeader fileHeader) throws IOException {
        if (FileHeader.PatchType.GIT_BINARY.equals((Object)fileHeader.getPatchType())) {
            return false;
        }
        if (!PatchApplier.hasCrLf(fileHeader)) {
            Throwable throwable = null;
            Object var4_5 = null;
            try (FileInputStream input = new FileInputStream(f);){
                return RawText.isCrLfText(input);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return false;
    }

    private static boolean hasCrLf(FileHeader fileHeader) {
        if (FileHeader.PatchType.GIT_BINARY.equals((Object)fileHeader.getPatchType())) {
            return false;
        }
        block0: for (HunkHeader hunkHeader : fileHeader.getHunks()) {
            byte[] buf = hunkHeader.getBuffer();
            int hunkEnd = hunkHeader.getEndOffset();
            int lineStart = hunkHeader.getStartOffset();
            while (lineStart < hunkEnd) {
                char first;
                int nextLineStart = RawParseUtils.nextLF(buf, lineStart);
                if (nextLineStart > hunkEnd) {
                    nextLineStart = hunkEnd;
                }
                if (nextLineStart <= lineStart) continue block0;
                if (nextLineStart - lineStart > 1 && ((first = (char)(buf[lineStart] & 0xFF)) == ' ' || first == '-') && buf[nextLineStart - 2] == 13) {
                    return true;
                }
                lineStart = nextLineStart;
            }
        }
        return false;
    }

    /*
     * Loose catch block
     */
    private ObjectId hash(File f) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            ObjectId objectId;
            SHA1InputStream shaStream;
            FileInputStream fis;
            block16: {
                block15: {
                    fis = new FileInputStream(f);
                    shaStream = new SHA1InputStream(fis, f.length());
                    shaStream.transferTo(OutputStream.nullOutputStream());
                    objectId = shaStream.getHash().toObjectId();
                    if (shaStream == null) break block15;
                    shaStream.close();
                }
                if (fis == null) break block16;
                fis.close();
            }
            return objectId;
            {
                catch (Throwable throwable2) {
                    try {
                        if (shaStream != null) {
                            shaStream.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (fis != null) {
                            fis.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private boolean checkOid(ObjectId baseId, ObjectId id, DiffEntry.ChangeType type, File f, String path, Result result) throws IOException {
        boolean hashOk = false;
        if (id != null) {
            hashOk = baseId.equals(id);
            if (!hashOk && DiffEntry.ChangeType.ADD.equals((Object)type) && ObjectId.zeroId().equals(baseId)) {
                hashOk = Constants.EMPTY_BLOB_ID.equals(id);
            }
        } else if (!this.inCore()) {
            hashOk = ObjectId.zeroId().equals(baseId) ? !f.exists() || f.length() == 0L : baseId.equals(this.hash(f));
        }
        if (!hashOk) {
            result.addError(MessageFormat.format(JGitText.get().applyBinaryBaseOidWrong, path), path, null);
        }
        return hashOk;
    }

    private boolean inCore() {
        return this.beforeTree != null;
    }

    @Nullable
    private ContentStreamLoader applyBinary(String path, File f, FileHeader fh, DirCacheCheckout.StreamSupplier inputSupplier, ObjectId id, Result result) throws UnsupportedOperationException, IOException {
        if (!fh.getOldId().isComplete() || !fh.getNewId().isComplete()) {
            result.addError(MessageFormat.format(JGitText.get().applyBinaryOidTooShort, path), path, null);
            return null;
        }
        BinaryHunk hunk = fh.getForwardBinaryHunk();
        int start = RawParseUtils.nextLF(hunk.getBuffer(), hunk.getStartOffset());
        int length = hunk.getEndOffset() - start;
        switch (hunk.getType()) {
            case LITERAL_DEFLATED: {
                if (!this.checkOid(fh.getOldId().toObjectId(), id, fh.getChangeType(), f, path, result)) {
                    return null;
                }
                DirCacheCheckout.StreamSupplier supp = () -> new InflaterInputStream(new BinaryHunkInputStream(new ByteArrayInputStream(hunk.getBuffer(), start, length)));
                return new ContentStreamLoader(supp, hunk.getSize());
            }
            case DELTA_DEFLATED: {
                byte[] base;
                Throwable throwable = null;
                Object var12_14 = null;
                try (InputStream in = inputSupplier.load();){
                    base = IO.readWholeStream(in, 0).array();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                DirCacheCheckout.StreamSupplier supp = () -> new BinaryDeltaInputStream(base, new InflaterInputStream(new BinaryHunkInputStream(new ByteArrayInputStream(hunk.getBuffer(), start, length))));
                long finalSize = ((BinaryDeltaInputStream)supp.load()).getExpectedResultSize();
                return new ContentStreamLoader(supp, finalSize);
            }
        }
        throw new UnsupportedOperationException(MessageFormat.format(JGitText.get().applyBinaryPatchTypeNotSupported, hunk.getType().name()));
    }

    @Nullable
    private ContentStreamLoader applyText(RawText rt, FileHeader fh, Result result) throws IOException {
        ArrayList<ByteBuffer> oldLines = new ArrayList<ByteBuffer>(rt.size());
        int i2 = 0;
        while (i2 < rt.size()) {
            oldLines.add(rt.getRawString(i2));
            ++i2;
        }
        ArrayList<ByteBuffer> newLines = new ArrayList<ByteBuffer>(oldLines);
        int afterLastHunk = 0;
        int lineNumberShift = 0;
        int lastHunkNewLine = -1;
        boolean lastWasRemoval = false;
        boolean noNewLineAtEndOfNew = false;
        for (HunkHeader hunkHeader : fh.getHunks()) {
            ByteBuffer hunkLine;
            int j;
            int sz;
            if (hunkHeader.getNewStartLine() <= lastHunkNewLine) {
                result.addError(JGitText.get().applyTextPatchUnorderedHunks, fh.getOldPath(), hunkHeader);
                return null;
            }
            lastHunkNewLine = hunkHeader.getNewStartLine();
            byte[] b = new byte[hunkHeader.getEndOffset() - hunkHeader.getStartOffset()];
            System.arraycopy(hunkHeader.getBuffer(), hunkHeader.getStartOffset(), b, 0, b.length);
            RawText hrt = new RawText(b);
            ArrayList<ByteBuffer> hunkLines = new ArrayList<ByteBuffer>(hrt.size());
            int i3 = 0;
            while (i3 < hrt.size()) {
                hunkLines.add(hrt.getRawString(i3));
                ++i3;
            }
            if (hunkHeader.getNewStartLine() == 0) {
                if (fh.getHunks().size() == 1 && this.canApplyAt(hunkLines, newLines, 0)) {
                    newLines.clear();
                    break;
                }
                result.addError(JGitText.get().applyTextPatchSingleClearingHunk, fh.getOldPath(), hunkHeader);
                return null;
            }
            int applyAt = hunkHeader.getNewStartLine() - 1 + lineNumberShift;
            if (applyAt < afterLastHunk && lineNumberShift < 0) {
                applyAt = hunkHeader.getNewStartLine() - 1;
                lineNumberShift = 0;
            }
            if (applyAt < afterLastHunk) {
                result.addError(JGitText.get().applyTextPatchUnorderedHunkApplications, fh.getOldPath(), hunkHeader);
                return null;
            }
            boolean applies = false;
            int oldLinesInHunk = hunkHeader.getLinesContext() + hunkHeader.getOldImage().getLinesDeleted();
            if (oldLinesInHunk <= 1) {
                applies = this.canApplyAt(hunkLines, newLines, applyAt);
                if (!applies && lineNumberShift != 0) {
                    applyAt = hunkHeader.getNewStartLine() - 1;
                    applies = applyAt >= afterLastHunk && this.canApplyAt(hunkLines, newLines, applyAt);
                }
            } else {
                int maxShift = applyAt - afterLastHunk;
                int shift = 0;
                while (shift <= maxShift) {
                    if (this.canApplyAt(hunkLines, newLines, applyAt - shift)) {
                        applies = true;
                        applyAt -= shift;
                        break;
                    }
                    ++shift;
                }
                if (!applies) {
                    applyAt = hunkHeader.getNewStartLine() - 1 + lineNumberShift;
                    maxShift = newLines.size() - applyAt - oldLinesInHunk;
                    shift = 1;
                    while (shift <= maxShift) {
                        if (this.canApplyAt(hunkLines, newLines, applyAt + shift)) {
                            applies = true;
                            applyAt += shift;
                            break;
                        }
                        ++shift;
                    }
                }
            }
            if (!applies) {
                if (!this.allowConflicts) {
                    result.addError(JGitText.get().applyTextPatchCannotApplyHunk, fh.getOldPath(), hunkHeader);
                    return null;
                }
                result.addErrorWithGitConflict("cannot apply hunk", fh.getOldPath(), hunkHeader);
                newLines.add(Math.min(applyAt++, newLines.size()), this.asBytes("<<<<<<< HEAD"));
                applyAt += hunkHeader.getOldImage().lineCount;
                newLines.add(Math.min(applyAt++, newLines.size()), this.asBytes("======="));
                sz = hunkLines.size();
                j = 1;
                while (j < sz) {
                    hunkLine = (ByteBuffer)hunkLines.get(j);
                    if (!hunkLine.hasRemaining()) {
                        ++applyAt;
                        lastWasRemoval = false;
                    } else {
                        switch (hunkLine.array()[hunkLine.position()]) {
                            case 32: 
                            case 43: {
                                newLines.add(Math.min(applyAt++, newLines.size()), this.slice(hunkLine, 1));
                                break;
                            }
                        }
                    }
                    ++j;
                }
                newLines.add(Math.min(applyAt++, newLines.size()), this.asBytes(">>>>>>> PATCH"));
                continue;
            }
            lineNumberShift = applyAt - hunkHeader.getNewStartLine() + 1;
            sz = hunkLines.size();
            j = 1;
            while (j < sz) {
                hunkLine = (ByteBuffer)hunkLines.get(j);
                if (!hunkLine.hasRemaining()) {
                    ++applyAt;
                    lastWasRemoval = false;
                } else {
                    switch (hunkLine.array()[hunkLine.position()]) {
                        case 32: {
                            ++applyAt;
                            lastWasRemoval = false;
                            break;
                        }
                        case 45: {
                            newLines.remove(applyAt);
                            lastWasRemoval = true;
                            break;
                        }
                        case 43: {
                            newLines.add(applyAt++, this.slice(hunkLine, 1));
                            lastWasRemoval = false;
                            break;
                        }
                        case 92: {
                            if (lastWasRemoval || !this.isNoNewlineAtEnd(hunkLine)) break;
                            noNewLineAtEndOfNew = true;
                            break;
                        }
                    }
                }
                ++j;
            }
            afterLastHunk = applyAt;
        }
        if (lastHunkNewLine >= 0 && afterLastHunk == newLines.size()) {
            if (!noNewLineAtEndOfNew) {
                newLines.add(null);
            }
        } else if (!rt.isMissingNewlineAtEnd()) {
            newLines.add(null);
        }
        return PatchApplier.toContentStreamLoader(newLines);
    }

    private static ContentStreamLoader toContentStreamLoader(List<ByteBuffer> newLines) throws IOException {
        TemporaryBuffer.LocalFile buffer = new TemporaryBuffer.LocalFile(null);
        Throwable throwable = null;
        Object var3_4 = null;
        try (CountingOutputStream out = new CountingOutputStream(buffer);){
            Iterator<ByteBuffer> l = newLines.iterator();
            while (l.hasNext()) {
                ByteBuffer line = l.next();
                if (line == null) break;
                out.write(line.array(), line.position(), line.remaining());
                if (!l.hasNext()) continue;
                out.write(10);
            }
            return new ContentStreamLoader(buffer::openInputStream, out.getCount());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private ByteBuffer asBytes(String str) {
        return ByteBuffer.wrap(str.getBytes(this.charset));
    }

    private boolean canApplyAt(List<ByteBuffer> hunkLines, List<ByteBuffer> newLines, int line) {
        int sz = hunkLines.size();
        int limit = newLines.size();
        int pos = line;
        int j = 1;
        while (j < sz) {
            ByteBuffer hunkLine = hunkLines.get(j);
            if (!hunkLine.hasRemaining()) {
                if (pos >= limit || newLines.get(pos).hasRemaining()) {
                    return false;
                }
                ++pos;
            } else {
                switch (hunkLine.array()[hunkLine.position()]) {
                    case 32: 
                    case 45: {
                        if (pos >= limit || !newLines.get(pos).equals(this.slice(hunkLine, 1))) {
                            return false;
                        }
                        ++pos;
                        break;
                    }
                }
            }
            ++j;
        }
        return true;
    }

    private ByteBuffer slice(ByteBuffer b, int off) {
        int newOffset = b.position() + off;
        return ByteBuffer.wrap(b.array(), newOffset, b.limit() - newOffset);
    }

    private boolean isNoNewlineAtEnd(ByteBuffer hunkLine) {
        return Arrays.equals(NO_EOL, 0, NO_EOL.length, hunkLine.array(), hunkLine.position(), hunkLine.limit());
    }

    private static class ContentStreamLoader {
        DirCacheCheckout.StreamSupplier supplier;
        long length;

        ContentStreamLoader(DirCacheCheckout.StreamSupplier supplier, long length) {
            this.supplier = supplier;
            this.length = length;
        }
    }

    public static class Result {
        private ObjectId treeId;
        private List<String> paths;
        private List<Error> errors = new ArrayList<Error>();

        public List<String> getPaths() {
            return this.paths;
        }

        public ObjectId getTreeId() {
            return this.treeId;
        }

        public List<Error> getErrors() {
            return this.errors;
        }

        private void addError(String msg, String oldFileName, @Nullable HunkHeader hh) {
            this.errors.add(new Error(msg, oldFileName, hh, false));
        }

        private void addErrorWithGitConflict(String msg, String oldFileName, @Nullable HunkHeader hh) {
            this.errors.add(new Error(msg, oldFileName, hh, true));
        }

        public static class Error {
            final String msg;
            final String oldFileName;
            @Nullable
            final HunkHeader hh;
            final boolean isGitConflict;

            Error(String msg, String oldFileName, @Nullable HunkHeader hh, boolean isGitConflict) {
                this.msg = msg;
                this.oldFileName = oldFileName;
                this.hh = hh;
                this.isGitConflict = isGitConflict;
            }

            public boolean isGitConflict() {
                return this.isGitConflict;
            }

            public String toString() {
                if (this.hh != null) {
                    return MessageFormat.format(JGitText.get().patchApplyErrorWithHunk, this.oldFileName, this.hh, this.msg);
                }
                return MessageFormat.format(JGitText.get().patchApplyErrorWithoutHunk, this.oldFileName, this.msg);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || !(o instanceof Error)) {
                    return false;
                }
                Error error = (Error)o;
                return Objects.equals(this.msg, error.msg) && Objects.equals(this.oldFileName, error.oldFileName) && Objects.equals(this.hh, error.hh) && this.isGitConflict == error.isGitConflict;
            }

            public int hashCode() {
                return Objects.hash(this.msg, this.oldFileName, this.hh, this.isGitConflict);
            }
        }
    }

    private static class SHA1InputStream
    extends InputStream {
        private final SHA1 hash = SHA1.newInstance();
        private final InputStream in;

        SHA1InputStream(InputStream in, long size) {
            this.hash.update(Constants.encodedTypeString(3));
            this.hash.update((byte)32);
            this.hash.update(Constants.encodeASCII(size));
            this.hash.update((byte)0);
            this.in = in;
        }

        public SHA1 getHash() {
            return this.hash;
        }

        @Override
        public int read() throws IOException {
            int b = this.in.read();
            if (b >= 0) {
                this.hash.update((byte)b);
            }
            return b;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int n = this.in.read(b, off, len);
            if (n > 0) {
                this.hash.update(b, off, n);
            }
            return n;
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }
    }
}

