/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.PackIndex;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.NB;

class PackIndexV2
implements PackIndex {
    private static final long IS_O64 = 0x80000000L;
    private static final int FANOUT = 256;
    private static final int[] NO_INTS = new int[0];
    private static final byte[] NO_BYTES = new byte[0];
    protected byte[] packChecksum;
    private long objectCnt;
    private final long[] fanoutTable;
    int[][] names;
    byte[][] offset32;
    private byte[][] crc32;
    byte[] offset64;

    PackIndexV2(InputStream fd) throws IOException {
        byte[] fanoutRaw = new byte[1024];
        IO.readFully(fd, fanoutRaw, 0, fanoutRaw.length);
        this.fanoutTable = new long[256];
        int k = 0;
        while (k < 256) {
            this.fanoutTable[k] = NB.decodeUInt32(fanoutRaw, k * 4);
            ++k;
        }
        this.objectCnt = this.fanoutTable[255];
        this.names = new int[256][];
        this.offset32 = new byte[256][];
        this.crc32 = new byte[256][];
        k = 0;
        while (k < 256) {
            long bucketCnt = k == 0 ? this.fanoutTable[k] : this.fanoutTable[k] - this.fanoutTable[k - 1];
            if (bucketCnt == 0L) {
                this.names[k] = NO_INTS;
                this.offset32[k] = NO_BYTES;
                this.crc32[k] = NO_BYTES;
            } else {
                if (bucketCnt < 0L) {
                    throw new IOException(MessageFormat.format(JGitText.get().indexFileCorruptedNegativeBucketCount, bucketCnt));
                }
                long nameLen = bucketCnt * 20L;
                if (nameLen > 0x7FFFFFF7L) {
                    throw new IOException(JGitText.get().indexFileIsTooLargeForJgit);
                }
                int intNameLen = (int)nameLen;
                byte[] raw = new byte[intNameLen];
                int[] bin = new int[intNameLen >>> 2];
                IO.readFully(fd, raw, 0, raw.length);
                int i2 = 0;
                while (i2 < bin.length) {
                    bin[i2] = NB.decodeInt32(raw, i2 << 2);
                    ++i2;
                }
                this.names[k] = bin;
                this.offset32[k] = new byte[(int)(bucketCnt * 4L)];
                this.crc32[k] = new byte[(int)(bucketCnt * 4L)];
            }
            ++k;
        }
        k = 0;
        while (k < 256) {
            IO.readFully(fd, this.crc32[k], 0, this.crc32[k].length);
            ++k;
        }
        int o64cnt = 0;
        int k2 = 0;
        while (k2 < 256) {
            byte[] ofs = this.offset32[k2];
            IO.readFully(fd, ofs, 0, ofs.length);
            int p = 0;
            while (p < ofs.length) {
                if (ofs[p] < 0) {
                    ++o64cnt;
                }
                p += 4;
            }
            ++k2;
        }
        if (o64cnt > 0) {
            this.offset64 = new byte[o64cnt * 8];
            IO.readFully(fd, this.offset64, 0, this.offset64.length);
        } else {
            this.offset64 = NO_BYTES;
        }
        this.packChecksum = new byte[20];
        IO.readFully(fd, this.packChecksum, 0, this.packChecksum.length);
    }

    @Override
    public long getObjectCount() {
        return this.objectCnt;
    }

    @Override
    public long getOffset64Count() {
        return this.offset64.length / 8;
    }

    private int findLevelOne(long nthPosition) {
        int levelOne = Arrays.binarySearch(this.fanoutTable, nthPosition + 1L);
        if (levelOne >= 0) {
            long base = this.fanoutTable[levelOne];
            while (levelOne > 0 && base == this.fanoutTable[levelOne - 1]) {
                --levelOne;
            }
        } else {
            levelOne = -(levelOne + 1);
        }
        return levelOne;
    }

    private int getLevelTwo(long nthPosition, int levelOne) {
        long base = levelOne > 0 ? this.fanoutTable[levelOne - 1] : 0L;
        return (int)(nthPosition - base);
    }

    @Override
    public ObjectId getObjectId(long nthPosition) {
        int levelOne = this.findLevelOne(nthPosition);
        int p = this.getLevelTwo(nthPosition, levelOne);
        int p4 = p << 2;
        return ObjectId.fromRaw(this.names[levelOne], p4 + p);
    }

    @Override
    public long getOffset(long nthPosition) {
        int levelOne = this.findLevelOne(nthPosition);
        int levelTwo = this.getLevelTwo(nthPosition, levelOne);
        return this.getOffset(levelOne, levelTwo);
    }

    @Override
    public long findOffset(AnyObjectId objId) {
        int levelOne = objId.getFirstByte();
        int levelTwo = this.binarySearchLevelTwo(objId, levelOne);
        if (levelTwo == -1) {
            return -1L;
        }
        return this.getOffset(levelOne, levelTwo);
    }

    @Override
    public int findPosition(AnyObjectId objId) {
        int levelOne = objId.getFirstByte();
        int levelTwo = this.binarySearchLevelTwo(objId, levelOne);
        if (levelTwo < 0) {
            return -1;
        }
        long objsBefore = levelOne == 0 ? 0L : this.fanoutTable[levelOne - 1];
        return (int)objsBefore + levelTwo;
    }

    private long getOffset(int levelOne, int levelTwo) {
        long p = NB.decodeUInt32(this.offset32[levelOne], levelTwo << 2);
        if ((p & 0x80000000L) != 0L) {
            return NB.decodeUInt64(this.offset64, 8 * (int)(p & 0xFFFFFFFF7FFFFFFFL));
        }
        return p;
    }

    @Override
    public long findCRC32(AnyObjectId objId) throws MissingObjectException {
        int levelOne = objId.getFirstByte();
        int levelTwo = this.binarySearchLevelTwo(objId, levelOne);
        if (levelTwo == -1) {
            throw new MissingObjectException(objId.copy(), "unknown");
        }
        return NB.decodeUInt32(this.crc32[levelOne], levelTwo << 2);
    }

    @Override
    public boolean hasCRC32Support() {
        return true;
    }

    @Override
    public Iterator<PackIndex.MutableEntry> iterator() {
        return new EntriesIteratorV2(this);
    }

    @Override
    public void resolve(Set<ObjectId> matches, AbbreviatedObjectId id, int matchLimit) throws IOException {
        int[] data = this.names[id.getFirstByte()];
        int max = this.offset32[id.getFirstByte()].length >>> 2;
        int high = max;
        if (high == 0) {
            return;
        }
        int low = 0;
        do {
            int p;
            int cmp;
            if ((cmp = id.prefixCompare(data, PackIndexV2.idOffset(p = low + high >>> 1))) < 0) {
                high = p;
                continue;
            }
            if (cmp == 0) {
                while (p > 0 && id.prefixCompare(data, PackIndexV2.idOffset(p - 1)) == 0) {
                    --p;
                }
                while (p < max && id.prefixCompare(data, PackIndexV2.idOffset(p)) == 0) {
                    matches.add(ObjectId.fromRaw(data, PackIndexV2.idOffset(p)));
                    if (matches.size() > matchLimit) break;
                    ++p;
                }
                return;
            }
            low = p + 1;
        } while (low < high);
    }

    private static int idOffset(int p) {
        return (p << 2) + p;
    }

    private int binarySearchLevelTwo(AnyObjectId objId, int levelOne) {
        int[] data = this.names[levelOne];
        int high = this.offset32[levelOne].length >>> 2;
        if (high == 0) {
            return -1;
        }
        int low = 0;
        do {
            int mid;
            int mid4;
            int cmp;
            if ((cmp = objId.compareTo(data, (mid4 = (mid = low + high >>> 1) << 2) + mid)) < 0) {
                high = mid;
                continue;
            }
            if (cmp == 0) {
                return mid;
            }
            low = mid + 1;
        } while (low < high);
        return -1;
    }

    @Override
    public byte[] getChecksum() {
        return this.packChecksum;
    }

    private static class EntriesIteratorV2
    extends PackIndex.EntriesIterator {
        private int levelOne = 0;
        private int levelTwo = 0;
        private final PackIndexV2 packIndex;

        private EntriesIteratorV2(PackIndexV2 packIndex) {
            super(packIndex.objectCnt);
            this.packIndex = packIndex;
        }

        @Override
        protected void readNext() {
            while (this.levelOne < this.packIndex.names.length) {
                if (this.levelTwo < this.packIndex.names[this.levelOne].length) {
                    int idx = this.levelTwo / 5 * 4;
                    long offset = NB.decodeUInt32(this.packIndex.offset32[this.levelOne], idx);
                    if ((offset & 0x80000000L) != 0L) {
                        idx = 8 * (int)(offset & 0xFFFFFFFF7FFFFFFFL);
                        offset = NB.decodeUInt64(this.packIndex.offset64, idx);
                    }
                    super.setOffset(offset);
                    this.levelTwo += 5;
                    super.setIdBuffer(this.packIndex.names[this.levelOne], this.levelTwo - 5);
                    return;
                }
                this.levelTwo = 0;
                ++this.levelOne;
            }
            throw new NoSuchElementException();
        }
    }
}

