/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.IOException;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.zip.DataFormatException;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.errors.StoredObjectRepresentationNotAvailableException;
import org.eclipse.jgit.internal.storage.commitgraph.CommitGraph;
import org.eclipse.jgit.internal.storage.dfs.DfsBlock;
import org.eclipse.jgit.internal.storage.dfs.DfsBlockCache;
import org.eclipse.jgit.internal.storage.dfs.DfsBlockMidx;
import org.eclipse.jgit.internal.storage.dfs.DfsObjectRepresentation;
import org.eclipse.jgit.internal.storage.dfs.DfsObjectToPack;
import org.eclipse.jgit.internal.storage.dfs.DfsPackDescription;
import org.eclipse.jgit.internal.storage.dfs.DfsPackFile;
import org.eclipse.jgit.internal.storage.dfs.DfsReader;
import org.eclipse.jgit.internal.storage.dfs.DfsStreamKey;
import org.eclipse.jgit.internal.storage.dfs.ReadableChannel;
import org.eclipse.jgit.internal.storage.file.PackBitmapIndex;
import org.eclipse.jgit.internal.storage.file.PackIndex;
import org.eclipse.jgit.internal.storage.file.PackReverseIndex;
import org.eclipse.jgit.internal.storage.midx.MultiPackIndex;
import org.eclipse.jgit.internal.storage.midx.MultiPackIndexLoader;
import org.eclipse.jgit.internal.storage.pack.ObjectToPack;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.internal.storage.pack.PackOutputStream;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BitmapIndex;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdSet;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.util.BlockList;

public final class DfsPackFileMidx
extends DfsPackFile {
    private static final int REF_POSITION = 0;
    private final List<DfsPackFile> packs;
    private final DfsPackFile[] packsInIdOrder;
    private MultiPackIndex midx;
    private final DfsPackFileMidx base;
    private final VOffsetCalculator offsetCalculator;

    static DfsPackFileMidx create(DfsBlockCache cache, DfsPackDescription desc, List<DfsPackFile> reqPacks, DfsPackFileMidx base) {
        return new DfsPackFileMidx(cache, desc, reqPacks, base);
    }

    private DfsPackFileMidx(DfsBlockCache cache, DfsPackDescription desc, List<DfsPackFile> requiredPacks, @Nullable DfsPackFileMidx base) {
        super(cache, desc);
        this.base = base;
        this.packs = requiredPacks;
        String[] coveredPackNames = (String[])desc.getCoveredPacks().stream().map(DfsPackDescription::getPackName).toArray(String[]::new);
        this.packsInIdOrder = this.getPacksInMidxIdOrder(coveredPackNames);
        this.offsetCalculator = VOffsetCalculator.fromPacks(this.packsInIdOrder, base != null ? base.getOffsetCalculator() : null);
        this.length = this.offsetCalculator.getMaxOffset();
    }

    private MultiPackIndex midx(DfsReader ctx) throws IOException {
        AtomicReference<Object> loadedRef;
        if (this.midx != null) {
            return this.midx;
        }
        DfsStreamKey revKey = this.desc.getStreamKey(PackExt.MULTI_PACK_INDEX);
        DfsBlockCache.Ref cachedRef = this.cache.getOrLoadRef(revKey, 0L, () -> this.lambda$2(ctx, loadedRef = new AtomicReference<Object>(null), revKey));
        this.midx = cachedRef.get() != null ? (MultiPackIndex)cachedRef.get() : (MultiPackIndex)loadedRef.get();
        return this.midx;
    }

    private static RefWithSize loadMultiPackIndex(DfsReader ctx, DfsPackDescription desc) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ReadableChannel rc = ctx.db.openFile(desc, PackExt.MULTI_PACK_INDEX);){
            MultiPackIndex midx = MultiPackIndexLoader.read(Channels.newInputStream(rc));
            return new RefWithSize(midx, midx.getMemorySize());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private DfsPackFile[] getPacksInMidxIdOrder(String[] packNames) {
        Map byName = this.packs.stream().collect(Collectors.toUnmodifiableMap(p -> p.getPackDescription().getPackName(), Function.identity()));
        DfsPackFile[] result = new DfsPackFile[this.desc.getCoveredPacks().size()];
        int i2 = 0;
        while (i2 < packNames.length) {
            DfsPackFile pack = (DfsPackFile)byName.get(packNames[i2]);
            if (pack == null) {
                throw new IllegalStateException("Required pack missing");
            }
            result[i2] = pack;
            ++i2;
        }
        return result;
    }

    VOffsetCalculator getOffsetCalculator() {
        return this.offsetCalculator;
    }

    @Override
    public PackIndex getPackIndex(DfsReader ctx) {
        throw new IllegalStateException("Shouldn't use multipack index if the primary index is needed");
    }

    @Override
    public ObjectIdSet asObjectIdSet(DfsReader ctx) throws IOException {
        MultiPackIndex multiPackIndex = this.midx(ctx);
        return objectId -> multiPackIndex.hasObject(objectId);
    }

    @Override
    public PackReverseIndex getReverseIdx(DfsReader ctx) {
        throw new IllegalStateException("Shouldn't use multipack index if the reverse index is needed");
    }

    @Override
    public PackBitmapIndex getBitmapIndex(DfsReader ctx) throws IOException {
        if (this.base != null) {
            return this.base.getBitmapIndex(ctx);
        }
        DfsPackFile[] dfsPackFileArray = this.packsInIdOrder;
        int n = this.packsInIdOrder.length;
        int n2 = 0;
        while (n2 < n) {
            DfsPackFile pack = dfsPackFileArray[n2];
            PackBitmapIndex bitmapIndex = pack.getBitmapIndex(ctx);
            if (bitmapIndex != null) {
                return bitmapIndex;
            }
            ++n2;
        }
        return null;
    }

    @Override
    List<DfsPackFile> fullyIncludedIn(DfsReader ctx, BitmapIndex.BitmapBuilder need) throws IOException {
        ArrayList<DfsPackFile> fullyIncluded = new ArrayList<DfsPackFile>();
        for (DfsPackFile pack : this.packs) {
            List<DfsPackFile> includedPacks = pack.fullyIncludedIn(ctx, need);
            if (includedPacks.isEmpty()) continue;
            fullyIncluded.addAll(includedPacks);
        }
        if (this.base != null) {
            fullyIncluded.addAll(this.base.fullyIncludedIn(ctx, need));
        }
        return fullyIncluded;
    }

    @Override
    public CommitGraph getCommitGraph(DfsReader ctx) throws IOException {
        for (DfsPackFile pack : this.packs) {
            CommitGraph cg = pack.getCommitGraph(ctx);
            if (cg == null) continue;
            return cg;
        }
        return null;
    }

    private int getObjectCount(DfsReader ctx) throws IOException {
        int baseObjectCount = this.base == null ? 0 : this.base.getObjectCount(ctx);
        return this.midx(ctx).getObjectCount() + baseObjectCount;
    }

    public List<DfsPackFile> getCoveredPacks() {
        return this.packs;
    }

    public List<DfsPackFile> getAllCoveredPacks() {
        ArrayList<DfsPackFile> coveredPacks = new ArrayList<DfsPackFile>(this.packs);
        DfsPackFileMidx base = this.getMultipackIndexBase();
        while (base != null) {
            coveredPacks.addAll(base.getCoveredPacks());
            base = base.getMultipackIndexBase();
        }
        return coveredPacks;
    }

    public DfsPackFileMidx getMultipackIndexBase() {
        return this.base;
    }

    @Override
    public int findIdxPosition(DfsReader ctx, AnyObjectId id) throws IOException {
        int p = this.midx(ctx).findPosition(id);
        if (p >= 0) {
            int baseObjects = this.base == null ? 0 : this.base.getObjectCount(ctx);
            return p + baseObjects;
        }
        if (this.base == null) {
            return -1;
        }
        return this.base.findIdxPosition(ctx, id);
    }

    @Override
    public boolean hasObject(DfsReader ctx, AnyObjectId id) throws IOException {
        if (this.midx(ctx).hasObject(id)) {
            return true;
        }
        if (this.base == null) {
            return false;
        }
        return this.base.hasObject(ctx, id);
    }

    @Override
    ObjectLoader get(DfsReader ctx, AnyObjectId id) throws IOException {
        MultiPackIndex.PackOffset location = this.midx(ctx).find(id);
        if (location != null) {
            return this.packsInIdOrder[location.getPackId()].get(ctx, id);
        }
        if (this.base == null) {
            return null;
        }
        return this.base.get(ctx, id);
    }

    @Override
    ObjectLoader load(DfsReader ctx, long midxOffset) throws IOException {
        DfsPackOffset location = this.offsetCalculator.decode(midxOffset);
        if (location == null) {
            return null;
        }
        return location.getPack().load(ctx, location.getPackOffset());
    }

    @Override
    long findOffset(DfsReader ctx, AnyObjectId id) throws IOException {
        MultiPackIndex.PackOffset location = this.midx(ctx).find(id);
        if (location != null) {
            return this.offsetCalculator.encode(location);
        }
        if (this.base == null) {
            return -1L;
        }
        return this.base.findOffset(ctx, id);
    }

    @Override
    void resolve(DfsReader ctx, Set<ObjectId> matches, AbbreviatedObjectId id, int matchLimit) throws IOException {
        this.midx(ctx).resolve(matches, id, matchLimit);
        if (matches.size() < matchLimit && this.base != null) {
            this.base.resolve(ctx, matches, id, matchLimit);
        }
    }

    @Override
    void copyPackAsIs(PackOutputStream out, DfsReader ctx) throws IOException {
        for (DfsPackFile pack : this.packs) {
            pack.copyPackAsIs(out, ctx);
        }
        if (this.base != null) {
            this.base.copyPackAsIs(out, ctx);
        }
    }

    @Override
    void copyAsIs(PackOutputStream out, DfsObjectToPack src, boolean validate, DfsReader ctx) throws IOException, StoredObjectRepresentationNotAvailableException {
        if (src.pack != this) {
            throw new IllegalArgumentException("pack mismatch in object description");
        }
        DfsPackOffset location = this.offsetCalculator.decode(src.offset);
        src.offset = location.getPackOffset();
        location.getPack().copyAsIs(out, src, validate, ctx);
        src.offset = location.getPackStart() + location.getPackOffset();
    }

    @Override
    byte[] getDeltaHeader(DfsReader ctx, long pos) throws IOException, DataFormatException {
        DfsPackOffset location = this.offsetCalculator.decode(pos);
        return location.getPack().getDeltaHeader(ctx, location.getPackOffset());
    }

    @Override
    int getObjectType(DfsReader ctx, long pos) throws IOException {
        DfsPackOffset location = this.offsetCalculator.decode(pos);
        return location.getPack().getObjectType(ctx, location.getPackOffset());
    }

    @Override
    long getObjectSize(DfsReader ctx, AnyObjectId id) throws IOException {
        MultiPackIndex.PackOffset local = this.midx(ctx).find(id);
        if (local != null) {
            return this.packsInIdOrder[local.getPackId()].getObjectSize(ctx, id);
        }
        if (this.base == null) {
            return -1L;
        }
        return this.base.getObjectSize(ctx, id);
    }

    @Override
    long getObjectSize(DfsReader ctx, long pos) throws IOException {
        if (pos < 0L) {
            return -1L;
        }
        DfsPackOffset location = this.offsetCalculator.decode(pos);
        return location.getPack().getObjectSize(ctx, location.getPackOffset());
    }

    @Override
    boolean hasObjectSizeIndex(DfsReader ctx) {
        return false;
    }

    @Override
    int getObjectSizeIndexThreshold(DfsReader ctx) {
        return Integer.MAX_VALUE;
    }

    @Override
    long getIndexedObjectSize(DfsReader ctx, int idxPosition) {
        return -1L;
    }

    @Override
    List<DfsObjectToPack> findAllFromPack(DfsReader ctx, Iterable<ObjectToPack> objects, boolean skipFound) throws IOException {
        BlockList<DfsObjectToPack> tmp = new BlockList<DfsObjectToPack>();
        BlockList<ObjectToPack> notFoundHere = new BlockList<ObjectToPack>();
        for (ObjectToPack obj : objects) {
            DfsObjectToPack otp = (DfsObjectToPack)obj;
            if (skipFound && otp.isFound()) continue;
            long p = this.offsetCalculator.encode(this.midx(ctx).find(otp));
            if (p < 0L) {
                notFoundHere.add(otp);
                continue;
            }
            otp.setOffset(p);
            tmp.add(otp);
        }
        if (this.base != null && !notFoundHere.isEmpty()) {
            List<DfsObjectToPack> inChain = this.base.findAllFromPack(ctx, notFoundHere, skipFound);
            tmp.addAll(inChain);
        }
        tmp.sort(OFFSET_SORT);
        return tmp;
    }

    @Override
    void fillRepresentation(DfsObjectRepresentation r, long offset, DfsReader ctx) throws IOException {
        DfsPackOffset location = this.offsetCalculator.decode(offset);
        if (location == null) {
            throw new IllegalArgumentException("Invalid offset in midx");
        }
        location.getPack().fillRepresentation(r, location.getPackOffset(), ctx);
        r.offset = offset;
    }

    @Override
    void fillRepresentation(DfsObjectRepresentation r, long offset, DfsReader ctx, PackReverseIndex rev) {
        throw new UnsupportedOperationException();
    }

    @Override
    boolean isCorrupt(long offset) {
        DfsPackOffset location = this.offsetCalculator.decode(offset);
        if (location == null) {
            throw new IllegalArgumentException("Invalid offset in midx");
        }
        return location.getPack().isCorrupt(location.getPackOffset());
    }

    @Override
    DfsBlock readOneBlock(long pos, DfsReader ctx, ReadableChannel rc) throws IOException {
        DfsPackOffset location = this.offsetCalculator.decode(pos);
        return new DfsBlockMidx(location.getPack().readOneBlock(location.getPackOffset(), ctx, rc), location.getPackStart());
    }

    @Override
    DfsBlock getOrLoadBlock(long pos, DfsReader ctx) throws IOException {
        DfsPackOffset location = this.offsetCalculator.decode(pos);
        return new DfsBlockMidx(location.getPack().getOrLoadBlock(location.getPackOffset(), ctx), location.getPackStart());
    }

    private /* synthetic */ DfsBlockCache.Ref lambda$2(DfsReader dfsReader, AtomicReference atomicReference, DfsStreamKey dfsStreamKey) throws IOException {
        RefWithSize midx1 = DfsPackFileMidx.loadMultiPackIndex(dfsReader, this.desc);
        atomicReference.set(midx1.idx);
        return new DfsBlockCache.Ref<MultiPackIndex>(dfsStreamKey, 0L, midx1.size, midx1.idx);
    }

    static class DfsPackOffset {
        private DfsPackFile pack;
        private long packStart;
        private long offset;

        DfsPackOffset() {
        }

        private DfsPackOffset setValues(DfsPackFile pack, long packStart, long globalOffset) {
            this.pack = pack;
            this.packStart = packStart;
            this.offset = globalOffset;
            return this;
        }

        DfsPackFile getPack() {
            return this.pack;
        }

        long getPackStart() {
            return this.packStart;
        }

        long getPackOffset() {
            return this.offset - this.packStart;
        }
    }

    private record RefWithSize(MultiPackIndex idx, long size) {
    }

    static class VOffsetCalculator {
        private final DfsPackFile[] packs;
        private final long[] accSizes;
        private final long baseMaxOffset;
        private final VOffsetCalculator baseOffsetCalculator;
        private final DfsPackOffset poBuffer = new DfsPackOffset();

        static VOffsetCalculator fromPacks(DfsPackFile[] packsInIdOrder, VOffsetCalculator baseOffsetCalculator) {
            long[] accSizes = new long[packsInIdOrder.length + 1];
            accSizes[0] = 0L;
            int i2 = 0;
            while (i2 < packsInIdOrder.length) {
                accSizes[i2 + 1] = accSizes[i2] + packsInIdOrder[i2].getPackDescription().getFileSize(PackExt.PACK);
                ++i2;
            }
            return new VOffsetCalculator(packsInIdOrder, accSizes, baseOffsetCalculator);
        }

        VOffsetCalculator(DfsPackFile[] packs, long[] packSizes, VOffsetCalculator baseOffsetCalculator) {
            this.packs = packs;
            this.baseOffsetCalculator = baseOffsetCalculator;
            this.baseMaxOffset = baseOffsetCalculator != null ? baseOffsetCalculator.getMaxOffset() : 0L;
            this.accSizes = packSizes;
        }

        long encode(MultiPackIndex.PackOffset location) {
            if (location == null) {
                return -1L;
            }
            return location.getOffset() + this.accSizes[location.getPackId()] + this.baseMaxOffset;
        }

        DfsPackOffset decode(long voffset) {
            if (voffset == -1L) {
                return null;
            }
            if (voffset < this.baseMaxOffset) {
                return this.baseOffsetCalculator.decode(voffset);
            }
            long localOffset = voffset - this.baseMaxOffset;
            int i2 = 0;
            while (i2 < this.accSizes.length) {
                if (localOffset <= this.accSizes[i2]) {
                    return this.poBuffer.setValues(this.packs[i2 - 1], this.accSizes[i2 - 1] + this.baseMaxOffset, voffset);
                }
                ++i2;
            }
            throw new IllegalArgumentException("Asking offset beyond limits");
        }

        long getMaxOffset() {
            return this.accSizes[this.accSizes.length - 1] + this.baseMaxOffset;
        }
    }
}

